/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserElement {
    protected boolean isActive = true;
    protected MsgObject nameValues = new MsgObject();
    protected String threadNumber = "0";
    public static final String DEFAULT_THREAD_NO = "0";

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public abstract String getElementType();

    public boolean getIsActive() {
        return this.isActive;
    }

    public MsgObject getNameValues() {
        return this.nameValues;
    }

    public String postProcess(MsgObject msg, String currentName) throws MraldParserException {
        return currentName;
    }

    public String preProcess(MsgObject msg, String currentName) throws MraldParserException {
        return currentName;
    }

    public String getThreadNumber() {
        return this.threadNumber;
    }

    public void setThreadNumber(String thisThreadNumber) {
        this.threadNumber = thisThreadNumber;
    }

    public void process(String[] valueList) throws MraldParserException {
        int numOfArrayLists = valueList.length;
        StringTokenizer valueTokens = null;
        String valueArray = null;
        String name = null;
        String value = null;
        for (int i = 0; i < numOfArrayLists; ++i) {
            valueArray = valueList[i];
            valueTokens = new StringTokenizer(valueArray, "~");
            while (valueTokens.hasMoreTokens()) {
                String nvp = valueTokens.nextToken();
                int splitPoint = nvp.indexOf(":");
                if (splitPoint == -1) {
                    name = "Value";
                    value = nvp;
                } else {
                    name = nvp.substring(0, splitPoint);
                    value = nvp.substring(splitPoint + 1);
                    if (value.length() > 0 && name.indexOf("Table") > -1 && value.charAt(0) != '\"' && value.indexOf(32) > -1) {
                        value = "\"" + value + "\"";
                    }
                }
                this.nameValues.setValue(name, value);
            }
            String sqlNo = this.nameValues.getValue("SqlThread")[0];
            if (sqlNo.equals("")) continue;
            this.setThreadNumber(sqlNo);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nThis is a(n) ");
        ret.append(this.getElementType());
        ret.append(" element");
        ret.append("\nIt is ");
        if (!this.isActive) {
            ret.append("not ");
        }
        ret.append("active.");
        ret.append("\nIts type and memory location are " + super.toString());
        ret.append("\nIt contains the following in its nameValues: ");
        ret.append(this.nameValues.nameValuesToString());
        return ret.toString();
    }

    public void collectElementGroup(MsgObject msg, String currentName, String[] groupTags) {
        String[] names = currentName.split("~");
        String mainName = names[0];
        if (currentName.equals(mainName)) {
            for (int i = 0; i < groupTags.length; ++i) {
                String labelName = mainName + "~" + groupTags[i];
                String value = msg.getValue(labelName)[0];
                if (!value.equals("")) {
                    this.nameValues.setValue(groupTags[i], value);
                }
                msg.removeValue(labelName);
            }
        } else {
            String extension = names[1];
            String value = msg.getValue(currentName)[0];
            msg.setValue(mainName, extension + ":" + value);
            msg.removeValue(currentName);
        }
    }

    public static HashMap<String, ArrayList<ParserElement>> orderElements(ArrayList<ParserElement> qe) throws MraldException {
        HashMap<String, ArrayList<ParserElement>> orderedElements = new HashMap<String, ArrayList<ParserElement>>();
        ParserElement thisElement = null;
        ArrayList<Object> elements = new ArrayList();
        Integer maxNo = new Integer(0);
        Integer thisNo = new Integer(0);
        Integer newNo = new Integer(0);
        for (int i = 0; i < qe.size(); ++i) {
            thisElement = qe.get(i);
            String threadNo = thisElement.getThreadNumber();
            if (threadNo.equals("all")) {
                thisNo = new Integer("-1");
                threadNo = "-1";
                thisElement.setThreadNumber(threadNo);
            } else if (threadNo.contains(",")) {
                String[] nums = threadNo.split(",");
                for (int j = 0; j < nums.length; ++j) {
                    thisNo = new Integer(nums[j]);
                    String thisNoStr = thisNo.toString();
                    if (maxNo.compareTo(thisNo) < 0) {
                        maxNo = thisNo;
                    }
                    elements = orderedElements.containsKey(thisNoStr) ? orderedElements.get(thisNoStr) : new ArrayList();
                    thisElement.setThreadNumber(thisNoStr);
                    elements.add(thisElement);
                    orderedElements.put(thisNoStr, elements);
                }
            } else {
                thisNo = new Integer(threadNo);
            }
            if (threadNo.contains(",")) continue;
            if (maxNo.compareTo(thisNo) < 0) {
                maxNo = thisNo;
            }
            elements = orderedElements.containsKey(threadNo) ? orderedElements.get(thisElement.getThreadNumber()) : new ArrayList();
            elements.add(thisElement);
            orderedElements.put(thisElement.getThreadNumber(), elements);
        }
        maxNo = new Integer(maxNo + 1);
        ArrayList elementsWithAll = (ArrayList)orderedElements.get("-1");
        if (elementsWithAll != null) {
            for (int k = 0; k < elementsWithAll.size(); ++k) {
                thisElement = (SqlElements)elementsWithAll.get(k);
                for (int j = 0; j < maxNo; ++j) {
                    newNo = new Integer(j);
                    thisElement.setThreadNumber(newNo.toString());
                    elements = orderedElements.get(thisElement.getThreadNumber());
                    if (elements == null || elements.size() <= 0) continue;
                    elements.add(thisElement);
                    orderedElements.put(thisElement.getThreadNumber(), new ArrayList<Object>(elements));
                }
            }
            orderedElements.remove("-1");
        }
        if (orderedElements.get(DEFAULT_THREAD_NO) == null) {
            return orderedElements;
        }
        elements = orderedElements.get(DEFAULT_THREAD_NO);
        orderedElements.put(maxNo.toString(), orderedElements.get(DEFAULT_THREAD_NO));
        orderedElements.remove(DEFAULT_THREAD_NO);
        return orderedElements;
    }
}

