/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalJoinResultSet
implements ResultSet,
ResultSetMetaData {
    private final ResultSet leftRS;
    private final ResultSet rightRS;
    private final int[] leftCols;
    private final int[] rightCols;

    protected ExternalJoinResultSet(ResultSet left, int[] lJoin, ResultSet right, int[] rJoin, JoinType how) throws SQLException {
        this.leftRS = left;
        this.leftCols = lJoin;
        this.rightRS = right;
        this.rightCols = rJoin;
        if (this.leftCols.length != this.rightCols.length) {
            throw new SQLException("Column mismatch.");
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.leftRS.isBeforeFirst()) {
            this.leftRS.next();
        }
        if (this.rightRS.next()) {
            while (!this.testCursor()) {
                this.leftRS.next();
            }
            return true;
        }
        return false;
    }

    private boolean testCursor() throws SQLException {
        for (int i = 0; i < this.leftCols.length; ++i) {
            if (this.testCursorAtColumn(i)) continue;
            return false;
        }
        return true;
    }

    private boolean testCursorAtColumn(int index) throws SQLException {
        Object left = this.leftRS.getObject(this.leftCols[index]);
        Object right = this.rightRS.getObject(this.rightCols[index]);
        if (this.leftRS.wasNull() || this.rightRS.wasNull()) {
            return false;
        }
        return left.equals(right);
    }

    private ResultSet lookupRS(int col) throws SQLException {
        return col <= this.leftRS.getMetaData().getColumnCount() ? this.leftRS : this.rightRS;
    }

    private int lookupCol(int col) throws SQLException {
        int leftCols = this.leftRS.getMetaData().getColumnCount();
        return col <= leftCols ? col : col - leftCols;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.leftRS.close();
        }
        catch (SQLException e) {
            this.rightRS.close();
            throw e;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getString(this.lookupCol(columnIndex));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getBoolean(this.lookupCol(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getByte(this.lookupCol(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getShort(this.lookupCol(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getInt(this.lookupCol(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getLong(this.lookupCol(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getFloat(this.lookupCol(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getDouble(this.lookupCol(columnIndex));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.lookupRS(columnIndex).getBigDecimal(this.lookupCol(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getBytes(this.lookupCol(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getDate(this.lookupCol(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getTime(this.lookupCol(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getTimestamp(this.lookupCol(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getAsciiStream(this.lookupCol(columnIndex));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getUnicodeStream(this.lookupCol(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getBinaryStream(this.lookupCol(columnIndex));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getString(this.lookupCol(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBoolean(this.lookupCol(columnIndex));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getByte(this.lookupCol(columnIndex));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getShort(this.lookupCol(columnIndex));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getInt(this.lookupCol(columnIndex));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getLong(this.lookupCol(columnIndex));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getFloat(this.lookupCol(columnIndex));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getDouble(this.lookupCol(columnIndex));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBigDecimal(this.lookupCol(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBytes(this.lookupCol(columnIndex));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getDate(this.lookupCol(columnIndex));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getTime(this.lookupCol(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getTimestamp(this.lookupCol(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getAsciiStream(this.lookupCol(columnIndex));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getUnicodeStream(this.lookupCol(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBinaryStream(this.lookupCol(columnIndex));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getObject(this.lookupCol(columnIndex));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getObject(this.lookupCol(columnIndex));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int col = -1;
        try {
            col = this.leftRS.findColumn(columnName);
        }
        catch (SQLException sqle) {
            col = this.rightRS.findColumn(columnName);
        }
        if (col == -1) {
            throw new SQLException("Column not found.");
        }
        return col;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getCharacterStream(this.lookupCol(columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getCharacterStream(this.lookupCol(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getBigDecimal(this.lookupCol(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBigDecimal(this.lookupCol(columnIndex));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.leftRS.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.leftRS.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rightRS.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rightRS.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.lookupRS(columnIndex).getObject(this.lookupCol(columnIndex), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getRef(this.lookupCol(columnIndex));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getBlob(this.lookupCol(columnIndex));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getClob(this.lookupCol(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getArray(this.lookupCol(columnIndex));
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getObject(this.lookupCol(columnIndex), map);
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getRef(this.lookupCol(columnIndex));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getBlob(this.lookupCol(columnIndex));
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getClob(this.lookupCol(columnIndex));
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getArray(this.lookupCol(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.lookupRS(columnIndex).getDate(this.lookupCol(columnIndex), cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getDate(this.lookupCol(columnIndex), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.lookupRS(columnIndex).getTime(this.lookupCol(columnIndex), cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getTime(this.lookupCol(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.lookupRS(columnIndex).getTimestamp(this.lookupCol(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getTimestamp(this.lookupCol(columnIndex), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.lookupRS(columnIndex).getURL(this.lookupCol(columnIndex));
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.lookupRS(columnIndex).getURL(this.lookupCol(columnIndex));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("This method not implemented.");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.leftRS.getMetaData().getColumnCount() + this.rightRS.getMetaData().getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isAutoIncrement(this.lookupCol(column));
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isCaseSensitive(this.lookupCol(column));
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isSearchable(this.lookupCol(column));
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isCurrency(this.lookupCol(column));
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isNullable(this.lookupCol(column));
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().isSigned(this.lookupCol(column));
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnDisplaySize(this.lookupCol(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnLabel(this.lookupCol(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnName(this.lookupCol(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getSchemaName(this.lookupCol(column));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getPrecision(this.lookupCol(column));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getScale(this.lookupCol(column));
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getTableName(this.lookupCol(column));
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getCatalogName(this.lookupCol(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnType(this.lookupCol(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnTypeName(this.lookupCol(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.lookupRS(column).getMetaData().getColumnClassName(this.lookupCol(column));
    }

    private static final void print(ResultSet rs) throws SQLException {
        int i;
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            System.out.print(rs.getMetaData().getColumnName(i));
            System.out.print(i == rs.getMetaData().getColumnCount() ? (char)'\n' : '\t');
        }
        while (rs.next()) {
            for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                System.out.print(rs.getString(i));
                System.out.print(i == rs.getMetaData().getColumnCount() ? (char)'\n' : '\t');
            }
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.postgresql.Driver");
        Connection db = DriverManager.getConnection("jdbc:postgresql://brainsrv2.mitre.org:5432/digests", "postgres", "postgres");
        Statement stmt1 = db.createStatement();
        stmt1.execute("SET search_path TO ziph");
        ResultSet rs1 = stmt1.executeQuery("SELECT * FROM clusterstrategies ORDER BY cstrategy_id");
        Statement stmt2 = db.createStatement();
        stmt2.execute("SET search_path TO ziph");
        ResultSet rs2 = stmt2.executeQuery("SELECT * FROM clustervalues ORDER BY cstrategy_id");
        int[] col1 = new int[]{1};
        int[] col2 = new int[]{3};
        ExternalJoinResultSet join = new ExternalJoinResultSet(rs1, col1, rs2, col2, JoinType.INNER);
        ExternalJoinResultSet.print(join);
        ResultSet rs = stmt1.executeQuery("EXPLAIN SELECT * FROM clusterstrategies NATURAL JOIN clustervalues");
        ExternalJoinResultSet.print(rs);
        System.out.println("Done!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinType {
        INNER;

    }
}

