/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterElement
extends SqlElements
implements FormBuilderElement {
    protected int noOfOperators;
    protected int noOfValues;
    protected String type;

    public FilterElement() {
        this.elementType = "Filter";
    }

    public FilterElement(MsgObject msg) {
        super(msg);
        this.elementType = "Filter";
    }

    public static String buildValue(String table, String synonym, String field, String operator, String value) {
        StringBuffer ret = new StringBuffer();
        ret.append("Table");
        ret.append(":");
        ret.append(table);
        if (synonym != null) {
            ret.append("~");
            ret.append("Synomyn");
            ret.append(":");
            ret.append(synonym);
        }
        ret.append("~");
        ret.append("Field");
        ret.append(":");
        ret.append(field);
        ret.append("~");
        ret.append("Operator");
        ret.append(":");
        ret.append(operator);
        ret.append("~");
        ret.append("Value");
        ret.append(":");
        ret.append(value);
        return ret.toString();
    }

    @Override
    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer list = FBUtils.buildTableFieldDropDown(md, "Filter", num);
        StringBuffer opList = FBUtils.getOperatorList("Filter" + num, "");
        StringBuffer ret = new StringBuffer();
        ret.append("\n<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">");
        ret.append("<tr>");
        ret.append("<td><strong>Title:</strong></td>");
        ret.append("<td><input name=\"Filter");
        ret.append(num);
        ret.append("~label\" type=\"text\" size=\"30\"></td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>Field:</strong></td>");
        ret.append("<td>");
        ret.append(list.toString());
        ret.append("</td>");
        ret.append("<td><strong>Operator:</strong></td>");
        ret.append("<td>");
        ret.append(opList.toString());
        ret.append("</td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>Values:</strong></td>");
        ret.append("<td colspan=\"4\"><input name=\"Filter");
        ret.append(num);
        ret.append("\" type=\"text\" size=\"22\"> (Comma delmited list. No spaces you don't want in the values.)</td>");
        ret.append("</tr>");
        ret.append("\n</table>");
        return ret.toString();
    }

    @Override
    public Node getFBNode(Document document) {
        String value = this.nameValues.getValue("Value")[0];
        String title = this.nameValues.getValue("label")[0];
        Element ret = document.createElement("filter");
        if (this.table.equals("") || this.field.equals("") || title.equals("") || value.equals("")) {
            return null;
        }
        FBUtils.addTextNode(document, ret, "table", this.table);
        FBUtils.addTextNode(document, ret, "column", this.field);
        FBUtils.addTextNode(document, ret, "label", title);
        FBUtils.addTextNode(document, ret, "operator", this.operator);
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            FBUtils.addTextNode(document, ret, "value", values[i]);
        }
        return ret;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        if (this.nameValues.getValue("Value")[0].equals("") || this.field.equals("") || this.operator.equals("")) {
            return currentFromList;
        }
        if (!this.fromTableName.equals("") && !currentFromList.contains(this.fromTableName)) {
            currentFromList.add(this.fromTableName);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        this.noOfValues = this.nameValues.getValue("Value").length;
        this.noOfOperators = this.nameValues.getValue("Operator").length;
        if (this.field.equals("") || this.table.equals("")) {
            return currentWhereList;
        }
        this.setType();
        StringBuffer newValue = new StringBuffer();
        this.buildWhereString(newValue);
        String returnString = newValue.toString();
        if (!returnString.equals("") && !currentWhereList.contains(returnString)) {
            currentWhereList.add(" ( " + returnString + " )");
        }
        return currentWhereList;
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) {
        String[] groupTags = new String[]{"label"};
        this.collectElementGroup(msg, currentName, groupTags);
        return currentName;
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        String[] values = this.nameValues.getValue("Value");
        if (values.length == 1 && values[0].equals("") && this.operator.toUpperCase().indexOf("NULL") == -1) {
            this.isActive = false;
        }
        return currentName;
    }

    protected void setType() {
        this.type = this.nameValues.getValue("Type")[0];
    }

    protected void buildWhereString(StringBuffer ret) {
        if (this.operator.toUpperCase().indexOf("NULL") != -1) {
            this.buildWhereStringNull(ret);
            return;
        }
        if (this.operator.toUpperCase().equals("IN") || this.operator.toUpperCase().equals("NOT IN")) {
            this.buildWhereStringIn(ret);
            return;
        }
        if (this.noOfValues > 2 && (this.operator.equals("=") || this.operator.equals("!="))) {
            this.buildConvertToInListString(ret);
        } else {
            this.buildWhereStringNormal(ret);
        }
    }

    protected void buildWhereStringIn(StringBuffer ret) {
        for (int i = 0; i < this.noOfValues; ++i) {
            String value = this.nameValues.getValue("Value")[i];
            if (value.equals("")) continue;
            ret.append(this.table);
            ret.append(".");
            ret.append(this.field);
            ret.append(" ");
            ret.append(this.operator);
            ret.append(" ( ");
            ret.append(value);
            ret.append(" )");
            if (i >= this.noOfValues - 1) continue;
            ret.append(" OR ");
        }
    }

    protected void buildWhereStringNormal(StringBuffer ret) {
        String opToAdd = this.operator;
        if (this.operator.equals("starts")) {
            opToAdd = "like";
        }
        if (this.operator.equals("not starts")) {
            opToAdd = "not like";
        }
        for (int i = 0; i < this.noOfValues; ++i) {
            String value = this.nameValues.getValue("Value")[i];
            if ((value = MiscUtils.checkApostrophe(value)).equals("")) continue;
            if (this.operator.equals("like")) {
                value = "%" + value + "%";
            } else if (this.operator.equals("not like")) {
                value = "%" + value + "%";
            } else if (this.operator.equals("starts")) {
                value = value + "%";
            } else if (this.operator.equals("not starts")) {
                value = value + "%";
            }
            ret.append(this.table);
            ret.append(".");
            ret.append(this.field);
            ret.append(" ");
            ret.append(opToAdd);
            if (this.type.equals("String") || this.type.equals("Date") || this.type.equals("")) {
                ret.append(" '");
                ret.append(value);
                ret.append("'");
            } else {
                ret.append(" ");
                ret.append(value);
            }
            if (i >= this.noOfValues - 1) continue;
            ret.append(" OR ");
        }
    }

    protected void buildConvertToInListString(StringBuffer ret) {
        String opToAdd;
        char QUOTE = '\'';
        String SEPARATOR = ", ";
        if (this.operator.equals("=")) {
            opToAdd = " IN ";
        } else if (this.operator.equals("!=")) {
            opToAdd = " NOT IN ";
        } else {
            throw new RuntimeException("shouldn't be in here, then");
        }
        ret.append(this.table);
        ret.append(".");
        ret.append(this.field);
        ret.append(opToAdd);
        ret.append("( ");
        for (int i = 0; i < this.noOfValues; ++i) {
            String value = this.nameValues.getValue("Value")[i];
            if ((value = MiscUtils.checkApostrophe(value)).equals("")) continue;
            if (this.type.equals("String") || this.type.equals("Date") || this.type.equals("")) {
                ret.append(QUOTE);
                ret.append(value);
                ret.append(QUOTE);
            } else {
                ret.append(value);
            }
            if (i >= this.noOfValues - 1) continue;
            ret.append(SEPARATOR);
        }
        ret.append(" )");
    }

    protected void buildWhereStringNull(StringBuffer ret) {
        ret.append(this.table);
        ret.append(".");
        ret.append(this.field);
        ret.append(" ");
        ret.append(this.operator);
    }
}

