/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mitre.mrald.query.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Node
implements Comparable {
    private Map<Node, Edge> adjacentNodes = null;
    private ArrayList<Edge> attachedEdges = new ArrayList();
    private int costToReach = Integer.MAX_VALUE;
    private String name;
    private ArrayList<Edge> pathToReach = new ArrayList();

    public Node() {
        this.name = "";
    }

    public Node(String nodeName) {
        this.name = nodeName;
    }

    public void setCostToReach(int cost) {
        this.costToReach = cost;
    }

    public void setName(String nameVal) {
        this.name = nameVal;
    }

    public void setPath(ArrayList<Edge> newPath) {
        this.pathToReach = new ArrayList<Edge>(newPath);
    }

    public Map getAdjacentNodes() {
        if (this.adjacentNodes == null) {
            this.adjacentNodes = new HashMap<Node, Edge>();
            for (int i = 0; i < this.attachedEdges.size(); ++i) {
                Node edgeNode1 = this.attachedEdges.get(i).getNodes()[0];
                Node edgeNode2 = this.attachedEdges.get(i).getNodes()[1];
                if (edgeNode1 != this) {
                    this.adjacentNodes.put(edgeNode1, this.attachedEdges.get(i));
                    continue;
                }
                this.adjacentNodes.put(edgeNode2, this.attachedEdges.get(i));
            }
        }
        return this.adjacentNodes;
    }

    public ArrayList<Edge> getAttachedEdges() {
        return this.attachedEdges;
    }

    public int getCostToReach() {
        return this.costToReach;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Edge> getPath() {
        return this.pathToReach;
    }

    public void attachEdge(Edge newEdge) {
        for (int i = 0; i < this.attachedEdges.size(); ++i) {
            if (!this.attachedEdges.get(i).equals(newEdge)) continue;
            return;
        }
        this.attachedEdges.add(newEdge);
        this.adjacentNodes = null;
    }

    public int compareTo(Object o) {
        int returnVal = this.costToReach - ((Node)o).getCostToReach();
        if (returnVal != 0) {
            return returnVal;
        }
        returnVal = this.pathToReach.size() - ((Node)o).getPath().size();
        if (returnVal == 0) {
            returnVal = this.name.compareTo(((Node)o).getName());
        }
        return returnVal;
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append("Node: " + this.name);
        ret.append(" Cost to reach: " + this.costToReach);
        ret.append("\nPath to Reach: ");
        for (i = 0; i < this.pathToReach.size(); ++i) {
            ret.append(this.pathToReach.get(i).getQual());
            if (i >= this.pathToReach.size() - 1) continue;
            ret.append(", ");
        }
        ret.append("\nAttached Edges: ");
        for (i = 0; i < this.attachedEdges.size(); ++i) {
            ret.append("\n\t" + this.attachedEdges.get(i).getQual());
        }
        ret.append("\n");
        return ret.toString();
    }
}

