/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.query.FilterElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MraldException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrFilterElement
extends FilterElement
implements FormBuilderElement {
    public OrFilterElement() {
        this.elementType = "OrFilter";
    }

    public OrFilterElement(MsgObject msg) {
        super(msg);
        this.elementType = "OrFilter";
    }

    @Override
    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer list = FBUtils.buildTableFieldDropDown(md, "OrFilter", num);
        StringBuffer ret = new StringBuffer();
        ret.append("\n<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">");
        ret.append("<tr>");
        ret.append("<td><strong>Title:</strong></td>");
        ret.append("<td><input name=\"OrFilter");
        ret.append(num);
        ret.append("~label\" type=\"text\" size=\"30\"></td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>First Field:</strong></td>");
        ret.append("<td>");
        ret.append(list.toString().replaceAll("Table:", "Table1:").replaceAll("Field:", "Field1:"));
        ret.append("</td>");
        ret.append("<td><strong>First Operator:</strong></td>");
        ret.append("<td>");
        ret.append(FBUtils.getOperatorList("OrFilter" + num, "1"));
        ret.append("</td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>Second Field:</strong></td>");
        ret.append("<td>");
        ret.append(list.toString().replaceAll("Table:", "Table2:").replaceAll("Field:", "Field2:"));
        ret.append("</td>");
        ret.append("<td><strong>Second Operator:</strong></td>");
        ret.append("<td>");
        ret.append(FBUtils.getOperatorList("OrFilter" + num, "2"));
        ret.append("</td>");
        ret.append("</tr>");
        ret.append("<tr>");
        ret.append("<td><strong>Value:</strong></td>");
        ret.append("<td colspan=\"3\"><input name=\"OrFilter");
        ret.append(num);
        ret.append("\" type=\"text\" size=\"22\"></td>");
        ret.append("</tr>");
        ret.append("\n</table>");
        return ret.toString();
    }

    @Override
    public String postProcess(MsgObject msg, String currentName) {
        boolean valueEmpty;
        boolean value1Empty = this.nameValues.getValue("Value1")[0].equals("");
        boolean value2Empty = this.nameValues.getValue("Value2")[0].equals("");
        String op1 = this.nameValues.getValue("Operator1")[0];
        String op2 = this.nameValues.getValue("Operator2")[0];
        String[] values = this.nameValues.getValue("Value");
        boolean bl = valueEmpty = values.length == 1 && values[0].equals("");
        if (valueEmpty && value1Empty && op1.toUpperCase().indexOf("NULL") == -1 || valueEmpty && value2Empty && op2.toUpperCase().indexOf("NULL") == -1) {
            this.isActive = false;
        }
        return currentName;
    }

    @Override
    public Node getFBNode(Document document) {
        String field1 = this.nameValues.getValue("Field1")[0];
        String table1 = this.nameValues.getValue("Table1")[0];
        String operator1 = this.nameValues.getValue("Operator1")[0];
        String field2 = this.nameValues.getValue("Field2")[0];
        String table2 = this.nameValues.getValue("Table2")[0];
        String operator2 = this.nameValues.getValue("Operator2")[0];
        String value = this.nameValues.getValue("Value")[0];
        String label = this.nameValues.getValue("label")[0];
        if (table1.equals("") || field1.equals("") || label.equals("") || table2.equals("") || field2.equals("") || value.equals("")) {
            return null;
        }
        Element ret = document.createElement("orFilter");
        FBUtils.addTextNode(document, ret, "table1", table1);
        FBUtils.addTextNode(document, ret, "column1", field1);
        FBUtils.addTextNode(document, ret, "operator1", operator1);
        FBUtils.addTextNode(document, ret, "table2", table2);
        FBUtils.addTextNode(document, ret, "column2", field2);
        FBUtils.addTextNode(document, ret, "operator2", operator2);
        FBUtils.addTextNode(document, ret, "label", label);
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            FBUtils.addTextNode(document, ret, "value", values[i]);
        }
        return ret;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        String newValue = this.nameValues.getValue("Table1")[0];
        String synValue = this.nameValues.getValue("Synomyn1")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!newValue.equals("") && !currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        newValue = this.nameValues.getValue("Table2")[0];
        synValue = this.nameValues.getValue("Synomyn2")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!newValue.equals("") && !currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        String synValue;
        String newValue = "";
        String operator = null;
        String value = null;
        String table1 = this.nameValues.getValue("Table1")[0].toString();
        String table2 = this.nameValues.getValue("Table2")[0].toString();
        String linkType = this.nameValues.getValue("LinkType")[0].toString();
        if (linkType.equals("")) {
            linkType = "OR";
        }
        if (!(synValue = this.nameValues.getValue("Syn1")[0].toString()).equals("")) {
            table1 = synValue;
        }
        if (!(synValue = this.nameValues.getValue("Syn2")[0].toString()).equals("")) {
            table2 = synValue;
        }
        String field1 = this.nameValues.getValue("Field1")[0].toString();
        String field2 = this.nameValues.getValue("Field2")[0].toString();
        if (field1.equals("") || field2.equals("") || table1.equals("") || table2.equals("")) {
            return currentWhereList;
        }
        operator = this.nameValues.getValue("Operator1")[0];
        if (operator.toUpperCase().indexOf("NULL") < 0) {
            value = this.nameValues.getValue("Value1")[0];
            if (value.equals("")) {
                value = this.nameValues.getValue("Value")[0];
            }
            if (value.equals("")) {
                return currentWhereList;
            }
        }
        if (operator.equals("")) {
            operator = "=";
        } else if (operator.equals("like")) {
            value = "%" + value + "%";
        } else if (operator.equals("starts")) {
            operator = "like";
            value = value + "%";
        }
        newValue = "( ";
        newValue = operator.toUpperCase().indexOf("NULL") != -1 ? newValue + table1 + "." + field1 + " " + operator : newValue + table1 + "." + field1 + " " + operator + " '" + value + "'";
        newValue = newValue + " " + linkType + " ";
        operator = this.nameValues.getValue("Operator2")[0];
        if (operator.toUpperCase().indexOf("NULL") < 0) {
            value = this.nameValues.getValue("Value2")[0];
            if (value.equals("")) {
                value = this.nameValues.getValue("Value")[0];
            }
            if (value.equals("")) {
                return currentWhereList;
            }
        }
        if (operator.equals("")) {
            operator = "=";
        } else if (operator.equals("like")) {
            value = "%" + value + "%";
        } else if (operator.equals("starts")) {
            operator = "like";
            value = value + "%";
        }
        newValue = operator.toUpperCase().indexOf("NULL") != -1 ? newValue + table2 + "." + field2 + " " + operator : newValue + table2 + "." + field2 + " " + operator + " '" + value + "'";
        newValue = newValue + " )";
        if (!currentWhereList.contains(newValue)) {
            currentWhereList.add(newValue);
        }
        return currentWhereList;
    }
}

