/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.AbstractPivotFilter;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotAggregateFilter
extends AbstractPivotFilter {
    public PivotAggregateFilter() throws MraldException {
    }

    public PivotAggregateFilter(MsgObject msg) throws MraldException {
        super(msg);
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        String valueTable;
        String having_operator = this.nameValues.getValue("HavingOperator")[0];
        String having_value = this.nameValues.getValue("HavingOperatorOperator")[0];
        if (!(having_operator.equals("") || having_value.equals("") || this.operator.equals("") || currentFromList.contains(valueTable = this.nameValues.getValue("ValueTable")[0]))) {
            currentFromList.add(valueTable);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        String having_operator = this.nameValues.getValue("HavingOperator")[0];
        String having_value = this.nameValues.getValue("HavingOperatorOperator")[0];
        if (!(having_operator.equals("") || having_value.equals("") || this.operator.equals(""))) {
            StringBuffer clause = new StringBuffer();
            this.buildOuter(clause);
            this.buildInner(clause);
            currentWhereList.add(clause.toString());
        }
        return currentWhereList;
    }

    private void buildInner(StringBuffer clause) {
        String entityTable = this.nameValues.getValue("EntityTable")[0];
        String entityField = this.nameValues.getValue("EntityField")[0];
        clause.append("(SELECT ");
        clause.append(entityField);
        clause.append(" FROM ");
        clause.append(entityTable);
        clause.append(" WHERE ");
        this.buildInnerWhere(clause);
        clause.append(" GROUP BY ");
        clause.append(entityField);
        clause.append(" HAVING ");
        this.buildHaving(clause);
        clause.append(")");
    }

    private void buildInnerWhere(StringBuffer clause) {
        String valueField = this.nameValues.getValue("ValueField")[0];
        String value = this.nameValues.getValue("Value")[0];
        clause.append(valueField);
        clause.append(" ");
        clause.append(this.operator);
        if (this.operator.indexOf("NULL") < 0) {
            clause.append(" ");
            this.buildValue(clause, "Value", value, this.operator.endsWith("IN"));
        }
    }

    private void buildHaving(StringBuffer clause) {
        String having_operator = this.nameValues.getValue("HavingOperator")[0];
        String having_value = this.nameValues.getValue("HavingOperatorOperator")[0];
        clause.append("COUNT(*) ");
        clause.append(having_operator);
        clause.append(" ");
        clause.append(having_value);
    }

    public static String populateOptions(String pivot) {
        String[] pieces = PivotAggregateFilter.parse(pivot);
        StringBuffer result = new StringBuffer();
        MraldConnection db = new MraldConnection("db_camda.props");
        Statement stmt = db.createStatement();
        try {
            String sql = "SELECT COUNT(*) FROM (SELECT DISTINCT " + pieces[4] + " FROM " + pieces[3] + ") AS T";
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                result.append("<option/>");
                int numAttr = rs.getInt(1);
                for (int i = 1; i <= numAttr; ++i) {
                    result.append("<option value=\"");
                    result.append("HavingOperatorOperator");
                    result.append(":");
                    result.append(i);
                    PivotAggregateFilter.buildEAVinfo(result, pieces);
                    result.append("\">").append(i).append("</option>");
                }
            }
        }
        catch (SQLException e) {
            MraldOutFile.appendToFile(e.getMessage());
        }
        return result.toString();
    }

    public static void main(String[] args) throws MraldException {
        PivotAggregateFilter test = new PivotAggregateFilter();
        test.nameValues.setValue("EntityTable", "sf36summaryscores");
        test.nameValues.setValue("EntityField", "abt_id");
        test.nameValues.setValue("EntityType", "Numeric");
        test.nameValues.setValue("AttributeTable", "sf36summaryscores");
        test.nameValues.setValue("AttributeField", "sf36_code");
        test.nameValues.setValue("AttributeType", "String");
        test.nameValues.setValue("ValueTable", "sf36summaryscores");
        test.nameValues.setValue("ValueField", "sf36_value");
        test.nameValues.setValue("ValueType", "Numeric");
        test.nameValues.setValue("HavingOperator", ">=");
        test.nameValues.setValue("HavingOperatorOperator", "3");
        test.nameValues.setValue("Operator", "=");
        test.nameValues.setValue("Value", "0");
        test.setOperator();
        ArrayList<String> result = test.buildWhere(new ArrayList<String>());
        for (String name : test.nameValues.getNames()) {
            for (String value : test.nameValues.getValue(name)) {
                System.out.println(name + " == " + value);
            }
        }
        for (String sql : result) {
            System.out.println((Object)sql);
        }
    }
}

