/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.query.AbstractPivotFilter;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotFilter
extends AbstractPivotFilter {
    public PivotFilter() throws MraldException {
    }

    public PivotFilter(MsgObject msg) throws MraldException {
        super(msg);
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) throws MraldException {
        if (!this.field.equals("") && !this.operator.equals("")) {
            String attrTable = this.nameValues.getValue("AttributeTable")[0];
            String valueTable = this.nameValues.getValue("ValueTable")[0];
            if (!currentFromList.contains(attrTable)) {
                currentFromList.add(attrTable);
            }
            if (!currentFromList.contains(valueTable)) {
                currentFromList.add(valueTable);
            }
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        if (!this.field.equals("") && !this.operator.equals("")) {
            StringBuffer clause = new StringBuffer();
            this.buildOuter(clause);
            this.buildInner(clause);
            currentWhereList.add(clause.toString());
        }
        return currentWhereList;
    }

    private void buildInner(StringBuffer clause) {
        String entityTable = this.nameValues.getValue("EntityTable")[0];
        String entityField = this.nameValues.getValue("EntityField")[0];
        clause.append("(SELECT ");
        clause.append(entityField);
        clause.append(" FROM ");
        clause.append(entityTable);
        clause.append(" WHERE ");
        this.buildInnerWhere(clause);
        clause.append(")");
    }

    private void buildInnerWhere(StringBuffer clause) {
        String attributeField = this.nameValues.getValue("AttributeField")[0];
        String valueField = this.nameValues.getValue("ValueField")[0];
        String value = this.nameValues.getValue("Value")[0];
        clause.append(attributeField);
        clause.append("=");
        this.buildValue(clause, "Attribute", this.field, false);
        clause.append(" AND ");
        clause.append(valueField);
        clause.append(" ");
        clause.append(this.operator);
        if (this.operator.indexOf("NULL") < 0) {
            clause.append(" ");
            this.buildValue(clause, "Value", value, this.operator.endsWith("IN"));
        }
    }

    public static String populateOptions(String pivot) {
        String[] pieces = PivotFilter.parse(pivot);
        StringBuffer result = new StringBuffer();
        MraldConnection db = new MraldConnection("db_camda.props");
        Statement stmt = db.createStatement();
        try {
            String sql = "SELECT DISTINCT " + pieces[4] + " FROM " + pieces[3];
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                result.append("<option/>");
                do {
                    String attr = rs.getString(1);
                    result.append("<option value=\"");
                    result.append("Field");
                    result.append(":");
                    result.append(attr);
                    PivotFilter.buildEAVinfo(result, pieces);
                    result.append("\">").append(attr).append("</option>");
                } while (rs.next());
            }
        }
        catch (SQLException e) {
            MraldOutFile.logToFile(e);
        }
        return result.toString();
    }
}

