/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MraldException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeElement
extends SqlElements
implements FormBuilderElement {
    public RangeElement() {
        this.elementType = "Range";
    }

    public RangeElement(MsgObject msg) {
        super(msg);
        this.elementType = "Range";
    }

    @Override
    public String getFBHtml(DBMetaData md, int num, int thread) {
        StringBuffer ret = new StringBuffer();
        ret.append("<strong>Field :</strong>");
        ret.append(FBUtils.buildTableFieldDropDown(md, "Range", num));
        ret.append("&nbsp; &nbsp; <strong>Desired Field Label :</strong>");
        ret.append("<input name=\"Range");
        ret.append(num);
        ret.append("\" type=\"text\" size=\"22\">");
        return ret.toString();
    }

    @Override
    public Node getFBNode(Document document) {
        String table = this.nameValues.getValue("Table")[0];
        String field = this.nameValues.getValue("Field")[0];
        String label = this.nameValues.getValue("Value")[0];
        if (table.equals("") || field.equals("") || label.equals("")) {
            return null;
        }
        Element ret = document.createElement("range");
        Element tableElement = document.createElement("table");
        Text tableText = document.createTextNode(table);
        tableElement.appendChild(tableText);
        ret.appendChild(tableElement);
        Element fieldElement = document.createElement("column");
        Text fieldText = document.createTextNode(field);
        fieldElement.appendChild(fieldText);
        ret.appendChild(fieldElement);
        Element labelElement = document.createElement("label");
        Text labelText = document.createTextNode(label);
        labelElement.appendChild(labelText);
        ret.appendChild(labelElement);
        return ret;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) {
        String newValue = this.nameValues.getValue("Table")[0];
        String synValue = this.nameValues.getValue("Synomyn")[0];
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        if (!currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) throws MraldException {
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) {
        String newValue = " ";
        int noOfValues = this.nameValues.getValue("Value").length;
        if (noOfValues == 0) {
            return currentWhereList;
        }
        String table = this.nameValues.getValue("Table")[0].toString();
        String field = this.nameValues.getValue("Field")[0].toString();
        String synValue = this.nameValues.getValue("Synomyn")[0];
        if (!synValue.equals("")) {
            table = synValue;
        }
        String maxValue = this.nameValues.getValue("Max")[0].toString();
        String minValue = this.nameValues.getValue("Min")[0].toString();
        if (!minValue.equals("")) {
            newValue = !maxValue.equals("") ? newValue + " ( " + table + "." + field + " >= \"" + minValue + "\" AND " + table + "." + field + " <= \"" + maxValue + "\" ) " : table + "." + field + " >= \"" + minValue + "\"";
        } else if (!maxValue.equals("")) {
            newValue = table + "." + field + " <= \"" + maxValue + "\"";
        } else {
            return currentWhereList;
        }
        if (!currentWhereList.contains(newValue)) {
            currentWhereList.add(newValue);
        }
        return currentWhereList;
    }

    @Override
    public String preProcess(MsgObject msg, String currentName) {
        StringTokenizer currentNameToken = new StringTokenizer(currentName, "~");
        currentName = currentNameToken.nextToken();
        String newStr = currentName + "~" + "Min";
        String valueList = msg.getValue(newStr)[0];
        this.nameValues.setValue("Min", valueList);
        msg.removeValue(newStr);
        newStr = currentName + "~" + "Max";
        valueList = msg.getValue(newStr)[0];
        this.nameValues.setValue("Max", valueList);
        msg.removeValue(newStr);
        return currentName;
    }
}

