/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectElement
extends SqlElements {
    public SelectElement() {
        this.elementType = "Select";
    }

    public static String buildValue(String table, String synonym, String field, String as, String order) {
        StringBuffer ret = new StringBuffer();
        ret.append("Table");
        ret.append(":");
        ret.append(table);
        if (synonym != null) {
            ret.append("~");
            ret.append("Synomyn");
            ret.append(":");
            ret.append(synonym);
        }
        ret.append("~");
        ret.append("Field");
        ret.append(":");
        ret.append(field);
        if (as != null) {
            ret.append("~");
            ret.append("As");
            ret.append(":");
            ret.append(as);
        }
        ret.append("~");
        ret.append("Order");
        ret.append(":");
        ret.append(order);
        return ret.toString();
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) {
        String dbName = this.nameValues.getValue("DBName")[0];
        String schema = this.nameValues.getValue("Schema")[0];
        String table = this.nameValues.getValue("Table")[0];
        String synValue = this.nameValues.getValue("Synomyn")[0];
        if (!synValue.equals("")) {
            table = synValue;
        } else if (!dbName.equals("") && !schema.equals("")) {
            table = dbName + "." + schema + "." + table;
        }
        String newValue = table + "." + this.nameValues.getValue("Field")[0];
        String orderStr = this.nameValues.getValue("Order")[0];
        String asValue = this.nameValues.getValue("As")[0];
        if (!asValue.equals("")) {
            newValue = newValue + " AS \"" + asValue + "\"";
        }
        if (!currentSelectList.contains(newValue)) {
            currentSelectList.add(newValue + "~" + orderStr);
        }
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) {
        String dbName = this.nameValues.getValue("DBName")[0];
        String schema = this.nameValues.getValue("Schema")[0];
        String newValue = this.nameValues.getValue("Table")[0];
        String synValue = this.nameValues.getValue("Synomyn")[0];
        if (!dbName.equals("") && !schema.equals("")) {
            newValue = dbName + "." + schema + "." + newValue;
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "SelectElement 1: buildFrom: from Table Name is :" + newValue);
        }
        if (!synValue.equals("")) {
            newValue = newValue + " " + synValue;
        }
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "SelectElement: buildFrom: from Table Name is :" + newValue);
        if (!currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        return currentWhereList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }
}

