/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.query;

import java.util.ArrayList;
import org.mitre.mrald.query.SqlElements;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateElement
extends SqlElements {
    public UpdateElement() {
        this.elementType = "Update";
    }

    public static String buildValue(String table, String synonym, String field, String as, String order) {
        StringBuffer ret = new StringBuffer();
        ret.append("Table");
        ret.append(":");
        ret.append(table);
        if (synonym != null) {
            ret.append("~");
            ret.append("Synomyn");
            ret.append(":");
            ret.append(synonym);
        }
        ret.append("~");
        ret.append("Field");
        ret.append(":");
        ret.append(field);
        if (as != null) {
            ret.append("~");
            ret.append("As");
            ret.append(":");
            ret.append(as);
        }
        ret.append("~");
        ret.append("Order");
        ret.append(":");
        ret.append(order);
        return ret.toString();
    }

    @Override
    public ArrayList<String> buildGroupBy(ArrayList<String> currentGroupByList) throws MraldException {
        return currentGroupByList;
    }

    @Override
    public ArrayList<String> buildSelect(ArrayList<String> currentSelectList) {
        String newValue = this.nameValues.getValue("Field")[0];
        String value = this.nameValues.getValue("Value")[0];
        String typeStr = this.nameValues.getValue("Type")[0];
        if (typeStr != null) {
            if (typeStr.equals("Numeric") || typeStr.equals("Date")) {
                if (value == null || value.equals("null") || value.equals("")) {
                    if (!currentSelectList.contains(newValue = newValue + " = null ")) {
                        currentSelectList.add(newValue);
                    }
                    return currentSelectList;
                }
                if (typeStr.equals("Date")) {
                    value = " to_date('" + value + "', 'MM/DD/YYYY')";
                    if (!currentSelectList.contains(newValue = newValue + " = " + value)) {
                        currentSelectList.add(newValue);
                    }
                    return currentSelectList;
                }
            } else if (typeStr.equals("Binary")) {
                return currentSelectList;
            }
        }
        if (!currentSelectList.contains(newValue = newValue + " = '" + MiscUtils.checkApostrophe(value) + "'")) {
            currentSelectList.add(newValue);
        }
        return currentSelectList;
    }

    @Override
    public ArrayList<String> buildFrom(ArrayList<String> currentFromList) {
        String newValue = this.nameValues.getValue("Table")[0];
        if (newValue.equals("")) {
            return currentFromList;
        }
        if (!currentFromList.contains(newValue)) {
            currentFromList.add(newValue);
        }
        return currentFromList;
    }

    @Override
    public ArrayList<String> buildWhere(ArrayList<String> currentWhereList) throws MraldException {
        return currentWhereList;
    }

    @Override
    public ArrayList<String> buildOrderBy(ArrayList<String> currentOrderBy) throws MraldException {
        return currentOrderBy;
    }
}

