/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.mrald.query.BroadcastQuery;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DbPropsFilter;
import org.mitre.mrald.util.JdbcTemplates;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.OtherDbPropsSubscriber;
import org.mitre.mrald.util.SimpleTargetProvider;

public class InitServlet
extends HttpServlet {
    public static final String HSQLDB_PREFIX = "jdbc:hsqldb:file:";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String base_path = config.getServletContext().getRealPath("/");
        String config_dir = base_path + "WEB-INF/props/";
        Config.init(config_dir);
        Config.setProperty("BasePath", base_path);
        new OtherDbPropsSubscriber();
        this.setLatticeFactory();
        this.clearHsqldbLckFiles();
        MetaData.reload();
        BroadcastQuery.init();
        BroadcastQuery.setProvider(new SimpleTargetProvider());
        JdbcTemplates.init(base_path + "/WEB-INF");
        File installDT = new File(Config.getProperty("LOGPATH"), "installDT.txt");
        if (!installDT.exists()) {
            Date nowPlus = new Date(System.currentTimeMillis() + 120000L);
            DateFormat df = DateFormat.getDateTimeInstance();
            String fomrattedDate = df.format(nowPlus);
            MraldOutFile.appendToFile("installDT.txt", fomrattedDate);
        }
    }

    protected void setLatticeFactory() {
        Config.setLatticeFactory(new LatticeFactory());
    }

    protected void clearHsqldbLckFiles() {
        File config_dir = new File(Config.getProperty("BasePath") + "/WEB-INF/props/");
        File[] files = config_dir.listFiles(new DbPropsFilter());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String dbFileBase;
            File lckFile;
            Properties config = new Properties();
            try {
                FileInputStream in = new FileInputStream(files[i]);
                config.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                MraldOutFile.logToFile(e);
            }
            String url = Config.replacements(config.getProperty("DBSERVER", "")).trim();
            if (!url.startsWith(HSQLDB_PREFIX) || !(lckFile = new File((dbFileBase = url.substring(HSQLDB_PREFIX.length())) + ".lck")).exists()) continue;
            boolean deleted = lckFile.delete();
            MraldOutFile.appendToFile(lckFile + " found.  " + (deleted ? "Deleted." : "Delete attempt unsuccessful."));
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            String base_path = req.getSession().getServletContext().getRealPath("/");
            String config_dir = base_path + "WEB-INF/props/";
            Config.init(config_dir);
            Config.setProperty("BasePath", base_path);
        }
        catch (Exception e) {
            throw new ServletException("Config Location Corrupted");
        }
    }
}

