/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.specOutput;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.mitre.mrald.specOutput.CommonLineInfo;
import org.mitre.mrald.specOutput.Line;
import org.mitre.mrald.specOutput.SpecOutputException;
import org.mitre.mrald.util.TimeFormatException;
import org.mitre.mrald.util.TimeFormatter;

public class LineElement {
    private String elementNumber;
    private String dbTable;
    private String dbField;
    private String staticValue;
    private String formatType;
    private String specialTransform;
    private String order = "NONE";
    private String value = null;

    public String convertFromOraTime(String otime) {
        String year = otime.substring(0, 4);
        String month = otime.substring(5, 7);
        String day = otime.substring(8, 10);
        String hour = otime.substring(11, 13);
        String minute = otime.substring(14, 16);
        String second = otime.substring(17, 19);
        String calTime = month + "/" + day + "/" + year + " " + hour + ":" + minute + ":" + second;
        return calTime;
    }

    public String convertToTaamTime(String otime) throws SpecOutputException {
        int year = new Integer(otime.substring(0, 4));
        int month = new Integer(otime.substring(5, 7));
        int day = new Integer(otime.substring(8, 10));
        int hour = new Integer(otime.substring(11, 13));
        int minute = new Integer(otime.substring(14, 16));
        int second = new Integer(otime.substring(17, 19));
        GregorianCalendar thisDay = new GregorianCalendar(year, month, day, hour, minute, second);
        if (!CommonLineInfo.startDateSet) {
            CommonLineInfo.startDate = thisDay;
            CommonLineInfo.startDateSet = true;
        }
        int dayNo = this.calcDayNum(thisDay);
        DecimalFormat df = new DecimalFormat("00");
        String taamTime = dayNo + "," + df.format(hour) + ":" + df.format(minute);
        return taamTime;
    }

    public String convertToLatLong(String degrees, String latLong, boolean isLat) throws SpecOutputException {
        try {
            DecimalFormat numFormat = new DecimalFormat("##0.00");
            double latLongMin = new Double(latLong);
            int latLongMid = 0;
            double latLongSec = latLongMin * 3600.0;
            double latLongRem = 0.0;
            long degLong = new Long(degrees);
            latLongMid = (int)(latLongSec / 60.0);
            latLongRem = latLongSec % 60.0;
            String latLongPrec = "";
            if (!isLat) {
                if (degLong < 0L) {
                    degLong *= -1L;
                    latLongPrec = "W";
                } else {
                    latLongPrec = "E";
                }
            } else if (degLong < 0L) {
                degLong *= -1L;
                latLongPrec = "S";
            } else {
                latLongPrec = "N";
            }
            return latLongPrec + degLong + " " + latLongMid + " " + numFormat.format(latLongRem) + " ";
        }
        catch (Exception e) {
            SpecOutputException spec = new SpecOutputException(e.getMessage());
            throw spec;
        }
    }

    public String formatOutput(ResultSet rs, String initString, int cRow, Line cLine) throws SpecOutputException {
        try {
            if (this.dbField != null) {
                this.setValue(rs.getString(this.dbField));
            } else if (this.staticValue != null) {
                this.setValue(this.staticValue);
            }
            return this.formatOutput(initString, cRow, cLine);
        }
        catch (SQLException se) {
            SpecOutputException spec = new SpecOutputException(se.getMessage());
            throw spec;
        }
    }

    public String formatOutput(String initString, int cRow, Line cLine) throws SpecOutputException {
        String returnString = null;
        try {
            if (this.specialTransform.equals("MPM")) {
                String newDate = this.convertFromOraTime(this.value);
                if (CommonLineInfo.mpmValue == null) {
                    CommonLineInfo.mpmValue = newDate;
                    Calendar thisDate = (Calendar)TimeFormatter.formatDateTime(newDate, true);
                    int hoursToMinutes = thisDate.get(11) * 60;
                    int origMinutes = thisDate.get(12);
                    int thisMPM = hoursToMinutes + origMinutes;
                    int handleEarlyFlights = 1440;
                    Integer myMPM = new Integer(thisMPM += handleEarlyFlights);
                    returnString = initString + " " + myMPM.toString() + " ";
                } else {
                    Calendar origCDate = (Calendar)TimeFormatter.formatDateTime(CommonLineInfo.mpmValue, true);
                    int origDay = origCDate.get(5);
                    Calendar thisDate = (Calendar)TimeFormatter.formatDateTime(newDate, true);
                    int diffOfDays = thisDate.get(5) - origDay;
                    int daysToMinutes = diffOfDays * 24 * 60;
                    int hoursToMinutes = thisDate.get(11) * 60;
                    int origMinutes = thisDate.get(12);
                    int thisMPM = daysToMinutes + hoursToMinutes + origMinutes;
                    int handleEarlyFlights = 1440;
                    Integer myMPM = new Integer(thisMPM += handleEarlyFlights);
                    CommonLineInfo.mpmValue = null;
                    returnString = initString + " " + myMPM.toString() + " ";
                }
            } else if (this.specialTransform.equals("TAAMTIME")) {
                String taamDate = this.convertToTaamTime(this.value);
                returnString = initString + taamDate + " ";
            } else if (this.specialTransform.equals("LATLONG")) {
                boolean isLat = false;
                if (this.dbField.equalsIgnoreCase("latitude")) {
                    isLat = true;
                }
                int dotInd = this.value.indexOf(".");
                String degreeVal = null;
                String minVal = "0.0";
                if (dotInd > 0) {
                    degreeVal = this.value.substring(0, this.value.indexOf("."));
                    minVal = "0." + this.value.substring(this.value.indexOf(".") + 1);
                } else {
                    degreeVal = this.value;
                }
                returnString = initString + this.convertToLatLong(degreeVal, minVal, isLat);
            } else if (this.specialTransform.equals("ROWNUM")) {
                CommonLineInfo.setRowCount(CommonLineInfo.getRowCount() + 1);
                returnString = initString + CommonLineInfo.getRowCount() + " ";
            } else if (this.specialTransform.equals("LINEBREAK")) {
                returnString = this.value == null ? initString + " \n" : initString + this.value + " \n";
            } else if (this.specialTransform.equals("ALPHA")) {
                String alphaVal = "Z";
                if (this.value.equals("1")) {
                    alphaVal = "A";
                }
                if (this.value.equals("2")) {
                    alphaVal = "B";
                }
                if (this.value.equals("3")) {
                    alphaVal = "C";
                }
                if (this.value.equals("4")) {
                    alphaVal = "D";
                }
                if (this.value.equals("5")) {
                    alphaVal = "E";
                }
                if (this.value.equals("6")) {
                    alphaVal = "F";
                }
                if (this.value.equals("7")) {
                    alphaVal = "G";
                }
                if (this.value.equals("8")) {
                    alphaVal = "H";
                }
                if (this.value.equals("9")) {
                    alphaVal = "I";
                }
                if (this.value.equals("10")) {
                    alphaVal = "J";
                }
                if (this.value.equals("11")) {
                    alphaVal = "K";
                }
                if (this.value.equals("12")) {
                    alphaVal = "L";
                }
                if (this.value.equals("13")) {
                    alphaVal = "M";
                }
                if (this.value.equals("14")) {
                    alphaVal = "N";
                }
                if (this.value.equals("15")) {
                    alphaVal = "O";
                }
                if (this.value.equals("16")) {
                    alphaVal = "P";
                }
                if (this.value.equals("17")) {
                    alphaVal = "Q";
                }
                if (this.value.equals("18")) {
                    alphaVal = "R";
                }
                if (this.value.equals("19")) {
                    alphaVal = "S";
                }
                if (this.value.equals("20")) {
                    alphaVal = "T";
                }
                if (this.value.equals("21")) {
                    alphaVal = "U";
                }
                if (this.value.equals("22")) {
                    alphaVal = "V";
                }
                if (this.value.equals("23")) {
                    alphaVal = "W";
                }
                if (this.value.equals("24")) {
                    alphaVal = "X";
                }
                if (this.value.equals("25")) {
                    alphaVal = "Y";
                }
                if (this.value.equals("26")) {
                    alphaVal = "Z";
                }
                returnString = initString + alphaVal + " ";
            } else if (this.specialTransform.equals("Regular")) {
                returnString = this.value == null ? initString + " " : initString + this.value + " ";
            } else if (this.specialTransform.equals("DEFAULT")) {
                returnString = this.value == null ? initString + this.staticValue + " " : initString + this.value + " ";
            } else if (this.specialTransform.equals("XMLCOMPLEX_CLOSE")) {
                returnString = initString + ">" + "\n";
            } else if (this.specialTransform.equals("XMLCOMPLEX_BEGINATT")) {
                returnString = initString + "<" + this.staticValue + " ";
            } else if (this.specialTransform.equals("ATTRIBUTE")) {
                returnString = initString + " " + this.staticValue + " = \"" + this.value + "\" ";
            } else if (this.specialTransform.equals("XMLCOMPLEX_BEGIN")) {
                returnString = initString + "<" + this.staticValue + ">" + "\n";
            } else if (this.specialTransform.equals("XMLCOMPLEX_END")) {
                returnString = initString + "</" + this.staticValue + ">" + "\n";
            } else if (this.specialTransform.equals("XMLSIMPLE")) {
                returnString = this.value == null ? initString : initString + "<" + this.staticValue + ">" + this.value + "</" + this.staticValue + ">" + "\n";
            } else if (this.specialTransform.equals("NOSPACE")) {
                returnString = this.value == null ? initString : initString + this.value;
            } else if (this.specialTransform.equals("NOSPACE_ST")) {
                returnString = initString + this.staticValue;
            }
        }
        catch (TimeFormatException tfe) {
            SpecOutputException spec = new SpecOutputException(tfe.getMessage());
            throw spec;
        }
        return returnString;
    }

    public int calcDayNum(Calendar currentDate) throws SpecOutputException {
        int dayNo = 99;
        dayNo = currentDate.get(6) - CommonLineInfo.startDate.get(6) + 1;
        return dayNo;
    }

    public void setElementNumber(String thisElementNumber) {
        this.elementNumber = thisElementNumber;
    }

    public String getElementNumber() {
        return this.elementNumber;
    }

    public void setDbTable(String thisDbTable) {
        this.dbTable = thisDbTable;
    }

    public String getDbTable() {
        return this.dbTable;
    }

    public void setDbField(String thisDbField) {
        this.dbField = thisDbField;
    }

    public String getDbField() {
        return this.dbField;
    }

    public void setStaticValue(String thisStaticValue) {
        this.staticValue = thisStaticValue;
    }

    public String getStaticValue() {
        return this.staticValue;
    }

    public void setFormatType(String thisFormatType) {
        this.formatType = thisFormatType;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setSpecialTransform(String thisSpecialTransform) {
        this.specialTransform = thisSpecialTransform;
    }

    public String getSpecialTransform() {
        return this.specialTransform;
    }

    public void setOrder(String thisOrder) {
        this.order = thisOrder;
    }

    public String getOrder() {
        return this.order;
    }

    public void setValue(ResultSet rs) throws SpecOutputException {
        try {
            if (this.dbField != null) {
                this.value = rs.getString(this.dbField);
            }
        }
        catch (SQLException se) {
            SpecOutputException spec = new SpecOutputException(se.getMessage());
            throw spec;
        }
    }

    public void setValue(String thisValue) {
        this.value = thisValue;
    }

    public String getValue() {
        return this.value;
    }
}

