/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.TableMetaData;

public class AllTablesMultiDbListTag
extends TagSupport {
    String schema;
    String displayTables = "true";
    String datasource = "";

    public String getBody() throws SQLException {
        DBMetaData md = MetaData.getDbMetaData(this.datasource);
        ArrayList tableList = new ArrayList();
        tableList = (ArrayList)md.getAllTableMetaData();
        StringBuffer buffer = new StringBuffer();
        String inputType = "hidden";
        if (this.displayTables.equals("true")) {
            buffer.append("\n<tr><td colspan=\"3\">");
            buffer.append("<b>Select Tables to be Used:</b></td></tr>");
            inputType = "checkbox";
        }
        for (int i = 0; i < tableList.size(); ++i) {
            TableMetaData table = (TableMetaData)tableList.get(i);
            String tableName = table.getName();
            if (this.displayTables.equals("true")) {
                buffer.append("\n<tr>");
                buffer.append("<td width=7 align='center'>");
            }
            buffer.append("<input type='" + inputType + "' name='" + "Table" + "' value='" + this.datasource + "." + tableName + "'></td>");
            if (!this.displayTables.equals("true")) continue;
            buffer.append("<td>" + tableName + "</td>");
            buffer.append("<td>" + table.getComments() + "</td>");
            buffer.append("</tr>");
        }
        return buffer.toString();
    }

    public int doStartTag() throws JspException {
        try {
            String tableList = this.getBody();
            this.pageContext.getOut().print(tableList);
            return 0;
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public String getDisplayTables() {
        return this.displayTables;
    }

    public void setDisplayTables(String displayTables) {
        this.displayTables = displayTables;
    }

    public void setDatasource(String ds) {
        this.datasource = ds;
    }
}

