/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;

public class BadFormStructureTag
extends TagSupport {
    String errorCode;
    int errorType;

    public int doStartTag() throws JspException {
        this.errorCode = this.pageContext.getRequest().getParameter("errorCode");
        System.out.println(this.errorCode);
        try {
            this.errorType = Integer.parseInt(this.errorCode);
            if (this.errorType > 3 || this.errorType < 0) {
                this.errorCode = this.errorCode + ", an invalid number";
                throw new NumberFormatException(this.errorCode + " is a bad value for errorCode");
            }
        }
        catch (NumberFormatException e) {
            try {
                this.pageContext.getOut().print("<h4>An invalid error code was passed.</h4>  '");
                this.pageContext.getOut().print(this.errorCode);
                this.pageContext.getOut().print("' was passed.  What should have been passed was an integer that is one of the static values in the MraldDijkstra class.  Please report this to your <a href=\"mailto:");
                this.pageContext.getOut().print(Config.getProperty("MAILTO"));
                this.pageContext.getOut().print("\">system administrator</a>.  In the meantime, check the possible reasons for this error below.");
            }
            catch (Exception ee) {
                throw new MraldError(ee);
            }
            return 0;
        }
        StringBuffer ret = new StringBuffer();
        if (this.errorType != 0) {
            ret.append("\n<h3>The following error(s) in form structure were detected</h3><ul>");
        }
        if (this.errorType == 2 || this.errorType == 3) {
            ret.append("\n<li>");
            ret.append("The form you are attempting to build does not have a unique join path among all tables.</li>");
        }
        if (this.errorType == 1 || this.errorType == 3) {
            ret.append("\n<li>");
            ret.append("The form you are attempting to build does not have a complete join path among all tables.</li>");
        }
        if (this.errorType != 0) {
            ret.append("</ul><br>Please use the browsers back button to correct the form.  For more information, see the description below of the restrictions on table and join structures in an MRALD form.");
        }
        ret.append("<hr>");
        try {
            this.pageContext.getOut().print(ret.toString());
        }
        catch (IOException e) {
            throw new MraldError(e);
        }
        return 0;
    }
}

