/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.admin.ErrFileFilter;
import org.mitre.mrald.util.Config;

public class ErrListTag
extends TagSupport {
    long now = System.currentTimeMillis();

    public StringBuffer deleteLink(String filename, int i) {
        File errFile = new File(Config.getProperty("LOGPATH"), filename);
        boolean olderThanAWeek = this.now - errFile.lastModified() > 604800000L;
        StringBuffer ret = new StringBuffer();
        ret.append(" &nbsp; ( ");
        ret.append(this.formatDate(errFile.lastModified()));
        ret.append(", ");
        ret.append(this.formatSize(errFile.length()));
        ret.append("kb ) &nbsp; ");
        ret.append("<input name=\"errFileDelete");
        ret.append(i);
        ret.append("\" value=\"");
        ret.append(filename);
        ret.append("\" type=\"checkbox\"");
        if (olderThanAWeek) {
            ret.append(" checked>");
        } else {
            ret.append(">");
        }
        ret.append(" Delete<br>");
        ret.append(Config.NEWLINE);
        return ret;
    }

    public int doStartTag() throws JspException {
        StringBuffer ret = new StringBuffer();
        File errDir = new File(Config.getProperty("LOGPATH"));
        Object[] files = errDir.list(new ErrFileFilter());
        Arrays.sort(files);
        for (int i = files.length - 1; i > 0; --i) {
            ret.append(" &nbsp; <a href=\"");
            ret.append(Config.getProperty("LOGURL"));
            ret.append((String)files[i]);
            ret.append("\">");
            ret.append((String)files[i]);
            ret.append("</a>");
            ret.append(this.deleteLink((String)files[i], i));
        }
        try {
            this.pageContext.getOut().print(ret.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public String formatDate(long dateTime) {
        SimpleDateFormat f = new SimpleDateFormat("EEEE, d MMMM yyyy, H:mm:ss");
        return f.format(new Date(dateTime));
    }

    public String formatSize(long fileSize) {
        double kbSize = (double)fileSize / 1024.0;
        DecimalFormat f = new DecimalFormat("#,##0.0");
        return f.format(kbSize);
    }
}

