/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.mitre.mrald.taglib.FormMetaDataTag;
import org.mitre.mrald.util.DBMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormMetaDataMultiDbTag
extends FormMetaDataTag {
    @Override
    public int doStartTag() throws JspException {
        this.init();
        String[] datasources = this.pageContext.getRequest().getParameterValues("Datasource");
        HashMap<String, DBMetaData> newDbmds = new HashMap<String, DBMetaData>();
        String[] tables = this.req.getParameterValues("Table");
        HashMap<String, ArrayList<String>> groupedTables = this.groupTables(datasources, tables);
        for (int i = 0; i < datasources.length; ++i) {
            String datasource = datasources[i];
            int tableDepth = 1;
            if (this.req.getParameter("tableDepth" + datasource) != null) {
                tableDepth = Integer.parseInt(this.req.getParameter("tableDepth" + datasource).trim());
            }
            ArrayList<String> tableList = groupedTables.get(datasource);
            String[] tableListTemp = new String[tableList.size()];
            int j = 0;
            Iterator<String> i$ = tableList.iterator();
            while (i$.hasNext()) {
                String tableName;
                tableListTemp[j] = tableName = i$.next();
                ++j;
            }
            DBMetaData newDbmd = this.setMetaData(datasource, tableListTemp, tableDepth);
            if (newDbmd == null) {
                throw new JspException("Database metadata for :" + datasource + " not found");
            }
            newDbmds.put(datasource, newDbmd);
        }
        this.pageContext.setAttribute("MultiDBMetaData", newDbmds, 2);
        return 0;
    }

    private HashMap<String, ArrayList<String>> groupTables(String[] datasources, String[] allTables) {
        HashMap<String, ArrayList<String>> groupedTables = new HashMap<String, ArrayList<String>>();
        for (String datasource : datasources) {
            ArrayList<String> tableList = new ArrayList<String>();
            for (String table : allTables) {
                String[] dbTable_pair = table.split("\\.");
                String dbName = dbTable_pair[0] + "." + dbTable_pair[1];
                if (!dbName.equals(datasource)) continue;
                tableList.add(dbTable_pair[2]);
            }
            groupedTables.put(datasource, tableList);
        }
        return groupedTables;
    }
}

