/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.FormUtils;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.NonPublicFilenameFilter;
import org.mitre.mrald.util.PublicFilenameFilter;
import org.mitre.mrald.util.User;
import org.mitre.mrald.util.UserFilenameFilter;

public class FormsListTag
extends TagSupport {
    User user = new User();
    public static final String SERVEFORMLISTITEM = "\n<br /> <a href=\"deleteForm.jsp?formid=<:formid:>&formAccess=<:formAccess:>\"><img src=\"images/delete.gif\" border=\"0\" /></a><a href=\"ShareForm.jsp?formid=<:formid:>&formAccess=<:formAccess:>\"><img src=\"images/share.gif\" border=\"0\" /></a><a href=\"FormServer.jsp?formid=<:formid:>&formAccess=<:formAccess:>&action=edit\"><img src=\"images/edit.gif\" border=\"0\" /></a><a href=\"FormServer.jsp?formid=<:formid:>&formAccess=<:formAccess:>&action=download\"><img src=\"images/down.gif\" border=\"0\" /></a><a href=\"uploadForm.jsp?formid=<:formid:>&formAccess=<:formAccess:>\"><img src=\"images/up.gif\" border=\"0\" /></a> ";
    private static final String PUBLICSERVEFORMLISTITEM = "\n<br /> ";
    public static final String SINGLE_LINK = "<a href=\"FormServer.jsp?formid=<:formid:>&formAccess=<:formAccess:>\"><:formtitle:></a>";
    public static final String DOUBLE_LINK = "<a href=\"FormServer.jsp?formid=<:formid:>-simple&formAccess=<:formAccess:>\"><:formtitle:></a> (<a href=\"FormServer.jsp?formid=<:formid:>&formAccess=<:formAccess:>\">adv</a>)";
    public static final String PUBLISH_LINK = "<input type=\"checkbox\" name=\"formid\"  value=\"<:formid:>\" /><b><:formtitle:>: <i><:userId:></i></b><br/>";
    private final int XML_EXISTS = 4;
    private final int SIMPLE_EXISTS = 2;
    private final int ADVANCED_EXISTS = 1;
    private String formType = "Personal";

    public int doStartTag() throws JspException {
        User user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
        if (user == null) {
            throw new JspException("Trying to access your " + this.formType + " forms, but your session seems to have expired.  Please <a href=\"MraldLogin.jsp\">log in</a>.");
        }
        String userid = user.getEmail();
        try {
            String temp;
            String formId;
            String listItem;
            int i;
            FilenameFilter filter;
            TreeSet<String> set = new TreeSet<String>();
            ArrayList<Object> list = new ArrayList();
            File dir = new File(Config.getProperty("customForms"));
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.formType.equals("Public")) {
                filter = new PublicFilenameFilter();
                list = new ArrayList<String>(Arrays.asList(((PublicFilenameFilter)filter).filter(dir)));
                userid = "public";
            } else if (this.formType.equals("PublicEdit")) {
                filter = new PublicFilenameFilter();
                list = new ArrayList<String>(Arrays.asList(((PublicFilenameFilter)filter).filter(dir)));
                userid = "public";
            } else if (this.formType.equals("All")) {
                filter = new NonPublicFilenameFilter();
                list = new ArrayList<String>(Arrays.asList(((NonPublicFilenameFilter)filter).filter(dir)));
            } else {
                filter = new UserFilenameFilter(userid);
                list = new ArrayList<String>(Arrays.asList(dir.list(filter)));
            }
            if (list.size() == 0) {
                if (this.formType.equals("Personal")) {
                    set.add("<br /><center>You have no personal forms.</center>");
                } else if (this.formType.equals("Public")) {
                    set.add("<p>Forms for general use should be placed here. The deployers of the system should pre build forms that will accommodate most of the users' needs and place them here. They can be listed by simple links, or they can be accessed via more complex javascript or applet menu systems. There are several of these freely available on the internet.</p>");
                }
            } else if (this.formType.equals("All")) {
                for (i = 0; i < list.size(); ++i) {
                    listItem = (String)list.get(i);
                    formId = this.getFormIdName(listItem);
                    if (listItem.lastIndexOf("@") < 1) continue;
                    String userId = listItem.substring(0, listItem.lastIndexOf("@"));
                    temp = MiscUtils.replace(PUBLISH_LINK, "<:formid:>", formId);
                    temp = MiscUtils.replace(temp, "<:formAccess:>", this.formType);
                    temp = MiscUtils.replace(temp, "<:formtitle:>", this.getTitle(Config.getProperty("customForms") + listItem));
                    temp = MiscUtils.replace(temp, "<:userId:>", userId);
                    set.add(temp);
                }
            } else {
                i = 0;
                int formGenState = 0;
                while (list.size() > 0 && i++ < 100) {
                    temp = "";
                    listItem = (String)list.get(0);
                    formId = this.getFormId(listItem);
                    String titleCheck = listItem;
                    formGenState = this.getFormGenState(list, formId, userid);
                    switch (formGenState) {
                        case 3: 
                        case 7: {
                            temp = DOUBLE_LINK;
                            break;
                        }
                        case 4: {
                            temp = SINGLE_LINK;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: {
                            temp = SINGLE_LINK;
                            break;
                        }
                        case 6: {
                            titleCheck = FormUtils.getXmlFileName(formId, userid);
                            FormUtils.deleteJspsForForm(formId, userid);
                            temp = SINGLE_LINK;
                        }
                        default: {
                            throw new RuntimeException("It appears no file exists, yet one was found.  The formId is " + formId);
                        }
                    }
                    this.removeAll(formId, userid, list);
                    temp = this.formType.equals("Public") ? MiscUtils.replace(PUBLICSERVEFORMLISTITEM + temp, "<:formid:>", formId) : MiscUtils.replace(SERVEFORMLISTITEM + temp, "<:formid:>", formId);
                    temp = MiscUtils.replace(temp, "<:formAccess:>", this.formType);
                    temp = MiscUtils.replace(temp, "<:formtitle:>", this.getTitle(Config.getProperty("customForms") + titleCheck));
                    set.add(temp);
                }
            }
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                this.pageContext.getOut().print(iter.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public String getFormId(String formItem) {
        String formId = formItem.substring(formItem.indexOf("_") + 1, formItem.lastIndexOf("."));
        int simpleloc = formId.lastIndexOf("-simple");
        if (simpleloc != -1) {
            formId = formId.substring(0, simpleloc);
        }
        return formId;
    }

    private String getFormIdName(String formItem) {
        String formId = formItem.substring(0, formItem.lastIndexOf("."));
        int simpleloc = formId.lastIndexOf("-simple");
        if (simpleloc != -1) {
            formId = formId.substring(0, simpleloc);
        }
        return formId;
    }

    private int getFormGenState(List list, String formId, String userid) {
        int ret = 0;
        if (list.contains(FormUtils.getJspFileName(formId, userid))) {
            ++ret;
        }
        if (list.contains(FormUtils.getSimpleJspName(formId, userid))) {
            ret += 2;
        }
        if (list.contains(FormUtils.getXmlFileName(formId, userid))) {
            ret += 4;
        }
        return ret;
    }

    public void removeAll(String formid, String userid, List list) {
        list.remove(FormUtils.getJspFileName(formid, userid));
        list.remove(FormUtils.getSimpleJspName(formid, userid));
        list.remove(FormUtils.getXmlFileName(formid, userid));
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String thisType) {
        this.formType = thisType;
    }

    String getTitle(String fileName) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = reader.readLine();
        String title = null;
        while (line != null) {
            if (line.indexOf("<title>") == -1) {
                line = reader.readLine();
                continue;
            }
            String nextLine = reader.readLine();
            while (nextLine != null && line.indexOf("</title>") == -1) {
                line = line + nextLine;
                nextLine = reader.readLine();
            }
            int start = line.indexOf("<title>") + 7;
            try {
                title = line.substring(start, line.indexOf("<", start + 1));
                title = title.replaceAll("\n|\r", "");
                break;
            }
            catch (StringIndexOutOfBoundsException e) {
                title = "None";
                break;
            }
        }
        reader.close();
        return title;
    }
}

