/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.User;

public class ValidateUserTag
extends TagSupport {
    protected String doAdminCheck = "no";
    protected String doEmailCheck = "no";
    protected String doCoiCheck = "no";
    protected User user;
    protected boolean forwarded = false;

    public int doStartTag() throws JspException {
        try {
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
            this.user = (User)this.pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
            if (this.user == null) {
                try {
                    res.sendRedirect(Config.getProperty("BaseUrl") + "/MraldLogin.jsp?pageurl=" + req.getRequestURL());
                }
                catch (IOException e) {
                    throw new JspException((Throwable)e);
                }
            }
            if (this.user.getGroup() == null) {
                try {
                    res.sendRedirect(Config.getProperty("BaseUrl") + "/MraldLogin.jsp?pageurl=" + req.getRequestURL());
                }
                catch (IOException e) {
                    throw new WorkflowStepException(e.getMessage());
                }
            }
            this.adminCheck();
            this.emailCheck();
            this.coiCheck();
            return 0;
        }
        catch (WorkflowStepException workflowStepException) {
            return 0;
        }
    }

    public int doEndTag() {
        if (this.user == null || this.forwarded) {
            return 5;
        }
        return 6;
    }

    public void adminCheck() throws JspException {
        if (this.doAdminCheck.equals("no")) {
            return;
        }
        if (this.user.getTypeId() < 3) {
            try {
                this.pageContext.forward("denied.jsp");
                this.forwarded = true;
            }
            catch (ServletException se) {
                throw new JspException((Throwable)se);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
    }

    public void emailCheck() throws JspException {
        if (this.doEmailCheck.equals("no")) {
            return;
        }
        if (!this.user.getEmail().equals(this.doEmailCheck)) {
            try {
                this.pageContext.forward("denied.jsp");
                this.forwarded = true;
            }
            catch (ServletException se) {
                throw new JspException((Throwable)se);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
    }

    public void coiCheck() throws JspException {
        if (this.doCoiCheck.equals("no")) {
            return;
        }
        if (this.user.getGroup().equals("Public")) {
            try {
                this.pageContext.forward("denied.jsp");
                this.forwarded = true;
            }
            catch (ServletException se) {
                throw new JspException((Throwable)se);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
    }

    public void setDoAdminCheck(String doAdminCheck) {
        this.doAdminCheck = doAdminCheck;
    }

    public void setDoEmailCheck(String doEmailCheck) {
        this.doEmailCheck = doEmailCheck;
    }

    public void setDoCoiCheck(String doCoiCheck) {
        this.doCoiCheck = doCoiCheck;
    }
}

