/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormConverter {
    File[] arrayToProcess = null;
    String xmlFileName = null;
    File xslFile = null;
    String xslFileName = null;

    public FormConverter() {
    }

    public FormConverter(String[] args) {
        this.processArgs(args);
        this.readXsl(this.xslFileName);
        if (this.xmlFileName == null) {
            File parentDir = new File(Config.getProperty("customForms"));
            this.arrayToProcess = parentDir.listFiles();
        } else if (this.xmlFileName.endsWith("/") || this.xmlFileName.endsWith("\\")) {
            File temp = new File(this.xmlFileName);
            if (!temp.exists()) {
                throw new MraldError("Could not find XML file " + temp.getName());
            }
            this.arrayToProcess = temp.listFiles();
        } else {
            File temp = new File(this.xmlFileName);
            if (!temp.exists()) {
                throw new MraldError("Could not find XML file " + temp.getName());
            }
            this.arrayToProcess = new File[1];
            this.arrayToProcess[0] = temp;
        }
        this.writeJsp();
    }

    protected void printUsage() {
        System.out.println("To use the FormConverter:");
        System.out.println("\tjava -cp <path to FormConverter.class> [options]");
        System.out.println("\tOptions include:");
        System.out.println("\t\t-usage -> this message");
        System.out.println("\t\t-xsl [path to file] -> use this XSL file (path to XSL file must be next arg)");
        System.out.println("\t\t-xml [path to file] -> process just this XML file or directory of xml files");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            new FormConverter(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-xsl")) {
                    this.xslFileName = args[++i];
                    continue;
                }
                if (arg.equals("-xml")) {
                    this.xmlFileName = args[++i];
                    continue;
                }
                if (!arg.equals("-usage") && !arg.equals("-?")) continue;
                this.printUsage();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MraldError(e);
        }
    }

    protected void readXsl(String xslLocation) {
        this.xslFile = new File(this.xslFileName);
        if (!this.xslFile.exists()) {
            throw new MraldError("Could not find XSL file " + this.xslFile.getName());
        }
    }

    protected void writeJsp() {
        for (int i = 0; i < this.arrayToProcess.length; ++i) {
            if (!this.arrayToProcess[i].getName().endsWith(".xml")) continue;
            this.xslTransform(this.arrayToProcess[i]);
        }
    }

    protected void xslTransform(File formXml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        String jspFileName = formXml.toString().substring(0, formXml.toString().indexOf(".xml")) + ".jsp";
        try {
            BufferedReader in = new BufferedReader(new FileReader(formXml));
            InputSource datafile = new InputSource(in);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(datafile);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(this.xslFile);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            PrintWriter ret = new PrintWriter(new FileWriter(jspFileName));
            StreamResult result = new StreamResult(ret);
            transformer.transform(source, result);
            ret.close();
        }
        catch (TransformerConfigurationException e) {
            throw new MraldError(e);
        }
        catch (TransformerException e) {
            throw new MraldError(e);
        }
        catch (SAXException e) {
            throw new MraldError(e);
        }
        catch (ParserConfigurationException e) {
            throw new MraldError(e);
        }
        catch (IOException e) {
            throw new MraldError(e);
        }
    }
}

