/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.mitre.mrald.util.AsynchronousMetaDataLoader;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.DbPropsFilter;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.TableMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    boolean listAllLinkTables = false;
    private static HashMap<String, DBMetaData> databases = new HashMap();
    public static String ADMIN_DB = "db_admin.props";

    public static void loadDbProperties(HashMap<String, DBMetaData> newDatabases) {
        databases = newDatabases;
    }

    public static HashMap<String, DBMetaData> getDbProperties() {
        return databases;
    }

    public static Properties getDbProperties(String key) {
        DBMetaData dbmd = databases.get(key);
        if (dbmd == null) {
            throw new NullPointerException("A data source with the name " + key + " has not been defined.  Please contact your administrator as the form you are using will not work until this is fixed.");
        }
        Properties ret = dbmd.getDbProps();
        return ret;
    }

    public static void putDbProperties(String key, DBMetaData md) {
        databases.put(key, md);
    }

    public static DBMetaData getDbMetaData(String key) {
        DBMetaData ret = databases.get(key);
        if (ret == null) {
            ret = databases.get("main");
        }
        return ret;
    }

    public static String getFileName(DBMetaData md) {
        for (String key : databases.keySet()) {
            if (md != databases.get(key)) continue;
            if (key.equals("main")) {
                return "config.properties";
            }
            return key;
        }
        return null;
    }

    public static String getDataSource(DBMetaData md) {
        for (String key : databases.keySet()) {
            if (md != databases.get(key)) continue;
            if (key.equals("main")) {
                return key;
            }
            return key;
        }
        return null;
    }

    public static void reload() {
        databases.clear();
        try {
            Properties mainProps = new Properties();
            mainProps.put("DBLOGIN", Config.getProperty("DBLOGIN"));
            mainProps.put("DBPASSWORD", Config.getProperty("DBPASSWORD"));
            mainProps.put("DBDRIVER", Config.getProperty("DBDRIVER"));
            mainProps.put("DBSERVER", Config.getProperty("DBSERVER"));
            mainProps.put("SCHEMA", Config.getProperty("SCHEMA"));
            mainProps.put("DBNAME", Config.getProperty("DBNAME"));
            try {
                Class.forName(Config.getProperty("DBDRIVER"));
            }
            catch (ClassNotFoundException e) {
                String mailText = MiscUtils.formatThrowable(e);
                e.printStackTrace();
                Mailer.send(Config.getProperty("MAILTO"), "MetaData", Config.getProperty("SMTPHOST"), mailText, "The driver for the main datasource, " + Config.getProperty("DBDRIVER") + ", could not be found");
            }
            DBMetaData main = new DBMetaData(mainProps);
            databases.put("main", main);
            Thread t = new Thread(new AsynchronousMetaDataLoader("main"));
            t.start();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        File config_dir = new File(Config.getProperty("BasePath") + "/WEB-INF/props/");
        File[] files = config_dir.listFiles(new DbPropsFilter());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            Properties config = new Properties();
            try {
                FileInputStream in = new FileInputStream(files[i]);
                config.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (config.getProperty("DBSERVER") == null) continue;
            try {
                Class.forName(config.getProperty("DBDRIVER"));
            }
            catch (ClassNotFoundException e) {
                String mailText = MiscUtils.formatThrowable(e);
                e.printStackTrace();
                Mailer.send(Config.getProperty("MAILTO"), "MetaData", Config.getProperty("SMTPHOST"), mailText, "The driver for the datasource in " + files[i] + ", " + config.getProperty("DBDRIVER") + ", could not be found");
                continue;
            }
            DBMetaData metaData = new DBMetaData(config);
            databases.put(files[i].getName(), metaData);
            Thread t = new Thread(new AsynchronousMetaDataLoader(files[i].getName()));
            t.start();
        }
    }

    public static void populateDBMetaData(String key) {
        try {
            Connection conn = new MraldConnection(key).getConnection();
            DatabaseMetaData dbmd = conn.getMetaData();
            String schema = MetaData.getDbProperties(key).getProperty("SCHEMA");
            DBMetaData md = MetaData.getDbMetaData(key);
            md.setState(DBMetaData.State.Loading);
            md.setDbVersion(dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion());
            String[] types = new String[]{"TABLE", "VIEW"};
            ResultSet rs = dbmd.getTables(null, schema, null, types);
            while (rs.next()) {
                String tableName = rs.getString(3);
                if (tableName.startsWith("BIN$")) continue;
                TableMetaData tableData = new TableMetaData(tableName);
                tableData.setComments(rs.getString(5));
                md.addTableMetaData(tableData);
            }
            md = MetaData.buildLinksSet(dbmd, md);
            md = MetaData.setColumnData(dbmd, md);
            md.setState(DBMetaData.State.Loaded);
        }
        catch (RuntimeException e) {
            MraldOutFile.logToFile(e);
            MetaData.removeDbMetaData(key);
            try {
                String mailText = MiscUtils.formatThrowable(e);
                Mailer.send(Config.getProperty("MAILTO"), "MetaData", Config.getProperty("SMTPHOST"), mailText, "Error loading " + key + " dataset:\n");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (SQLException e) {
            MraldOutFile.logToFile(e);
            MetaData.removeDbMetaData(key);
            try {
                String mailText = MiscUtils.formatThrowable(e);
                Mailer.send(Config.getProperty("MAILTO"), "MetaData", Config.getProperty("SMTPHOST"), mailText, "Error loading " + key + " dataset:\n");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected static void removeDbMetaData(String key) {
        databases.remove(key);
    }

    private static DBMetaData setColumnData(DatabaseMetaData dbmd, DBMetaData md) throws SQLException {
        ArrayList tables = (ArrayList)md.getAllTableMetaData();
        String schema = md.getDbProps().getProperty("SCHEMA");
        for (int i = 0; i < tables.size(); ++i) {
            TableMetaData tableData = (TableMetaData)tables.get(i);
            String tableName = tableData.getName();
            if (tableData == null || tableName.startsWith("BIN$")) continue;
            ResultSet rs = dbmd.getColumns(null, schema, tableName, null);
            while (rs.next()) {
                tableData.addColumn(rs.getString("COLUMN_NAME"), rs.getString("REMARKS"), rs.getInt("DATA_TYPE"));
            }
            rs.close();
            rs = dbmd.getPrimaryKeys(null, schema, tableName);
            while (rs.next()) {
                tableData.addPrimaryKey(rs.getString("COLUMN_NAME"));
            }
            rs.close();
        }
        return md;
    }

    private static DBMetaData buildLinksSet(DatabaseMetaData dbmd, DBMetaData md) throws SQLException {
        Collection<TableMetaData> tables = md.getAllTableMetaData();
        Iterator<TableMetaData> iter = tables.iterator();
        HashSet<Link> linkList = new HashSet<Link>();
        while (iter.hasNext()) {
            Link link;
            TableMetaData tableInfo = iter.next();
            String table = tableInfo.getName();
            ResultSet rs = dbmd.getImportedKeys(null, null, table);
            while (rs.next()) {
                link = new Link(rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"));
                linkList.add(link);
            }
            rs.close();
            rs = dbmd.getExportedKeys(null, null, table);
            while (rs.next()) {
                link = new Link(rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"));
                linkList.add(link);
            }
            rs.close();
        }
        md.setLinkList(linkList);
        return md;
    }

    public static Set<String> getDatasourceNames() {
        return databases.keySet();
    }

    public static DBMetaData getDataSubSet(String datasourceName, String[] tables, int tableDepth) throws MraldException {
        DBMetaData md = databases.get(datasourceName);
        return MetaData.getDataSubSet(md, tables, tableDepth);
    }

    public static DBMetaData getDataSubSet(DBMetaData dbmd, String[] tables, int tableDepth) throws MraldException {
        DBMetaData subDbmd = new DBMetaData();
        if (tables.length == 0) {
            throw new MraldException("No tables were chosen in the previous step.  Please go back and choose one or more tables.");
        }
        subDbmd.setOriginalTables(tables);
        HashSet<String> tableList = new HashSet<String>();
        tableList.addAll(Arrays.asList(tables));
        Iterator iter = tableList.iterator();
        HashSet<String> newTables = new HashSet<String>();
        if (tableDepth == 0) {
            Set<Link> links = MetaData.buildLinksSubSet(dbmd, tableList, true);
            while (iter.hasNext()) {
                String tableName = (String)iter.next();
                subDbmd.addTableMetaData(dbmd.getTableMetaData(tableName));
            }
            subDbmd.addLinks(links);
            return subDbmd;
        }
        Set<Link> links = MetaData.buildLinksSubSet(dbmd, tableList);
        Iterator<Link> linksIter = links.iterator();
        for (int i = 0; i < tableDepth; ++i) {
            if (tableDepth == 0) continue;
            while (iter.hasNext()) {
                String tableName = (String)iter.next();
                subDbmd.addTableMetaData(dbmd.getTableMetaData(tableName));
                while (linksIter.hasNext()) {
                    Link link = linksIter.next();
                    if (tableList.contains(link.getPtable())) {
                        String fKeyTable = link.getFtable();
                        newTables.add(link.getFtable());
                        subDbmd.addLink(link);
                        subDbmd.addTableMetaData(dbmd.getTableMetaData(fKeyTable));
                        continue;
                    }
                    String pKeyTable = link.getPtable();
                    newTables.add(link.getPtable());
                    subDbmd.addLink(link);
                    subDbmd.addTableMetaData(dbmd.getTableMetaData(pKeyTable));
                }
            }
            tableList.addAll(newTables);
            links = MetaData.buildLinksSubSet(dbmd, newTables);
            linksIter = links.iterator();
            iter = tableList.iterator();
        }
        links = MetaData.buildLinksSubSet(subDbmd, tableList, true);
        subDbmd.addLinks(links);
        return subDbmd;
    }

    private static Set<Link> buildLinksSubSet(DBMetaData md, Set tableSubSet) throws MraldException {
        HashSet<Link> linkSubSet = new HashSet<Link>();
        Set linkList = md.getLinkList();
        for (Link link : linkList) {
            if (tableSubSet.contains(link.getPtable())) {
                linkSubSet.add(link);
            }
            if (!tableSubSet.contains(link.getFtable())) continue;
            linkSubSet.add(link);
        }
        return linkSubSet;
    }

    private static Set<Link> buildLinksSubSet(DBMetaData md, Set tableSubSet, boolean checkBoth) throws MraldException {
        HashSet<Link> linkSubSet = new HashSet<Link>();
        Set linkList = md.getLinkList();
        for (Link link : linkList) {
            if (!tableSubSet.contains(link.getPtable()) || !tableSubSet.contains(link.getFtable())) continue;
            linkSubSet.add(link);
        }
        return linkSubSet;
    }
}

