/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLTranslator
extends AbstractStep {
    Connection conn;
    MsgObject msg;

    public static StringBuffer xslTransform(File xmlFile, File xslFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
            InputSource datafile = new InputSource(reader);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(datafile);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(xslFile);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            StringWriter ret = new StringWriter();
            StreamResult result = new StreamResult(ret);
            transformer.transform(source, result);
            return ret.getBuffer();
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new RuntimeException("\n** Transformer Factory error  ", tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException("\n** Transformation error ", te);
        }
        catch (SAXException sxe) {
            throw new RuntimeException("\n** SAXException error ", sxe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("\n** ParseConfiguration error ", pce);
        }
        catch (FileNotFoundException ioe) {
            throw new RuntimeException("\n** FileNotFoundException error ", ioe);
        }
        catch (IOException ioe) {
            throw new RuntimeException("\n** IOException error ", ioe);
        }
    }

    public static StringBuffer xslTransform(String formXml, String xsl) throws WorkflowStepException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            File stylesheet = new File(xsl);
            StringReader reader = new StringReader(formXml);
            InputSource datafile = new InputSource(reader);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(datafile);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            StringWriter ret = new StringWriter();
            StreamResult result = new StreamResult(ret);
            transformer.transform(source, result);
            return ret.getBuffer();
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new WorkflowStepException("\n** Transformer Factory error  " + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new WorkflowStepException("\n** Transformation error " + te.getMessage());
        }
        catch (SAXException sxe) {
            throw new WorkflowStepException("\n** SAXException error " + sxe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new WorkflowStepException("\n** ParseConfiguration error " + pce.getMessage());
        }
        catch (IOException ioe) {
            throw new WorkflowStepException("\n** IOException error " + ioe.getMessage());
        }
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.msg = msgObject;
            String formXml = this.msg.getValue("xmlFile")[0];
            String xmlString = null;
            BufferedReader in = new BufferedReader(new FileReader(formXml));
            if (in == null) {
                throw new WorkflowStepException("IOException in XSLTranslator.execute() " + formXml + " not found.");
            }
            String line = null;
            if (in.readLine() == null) {
                throw new WorkflowStepException("IOException in XSLTranslator.execute(). Could not read file " + formXml);
            }
            xmlString = in.readLine();
            while ((line = in.readLine()) != null) {
                xmlString = xmlString + line;
            }
            String formXsl = this.msg.getValue("formStylesheet")[0];
            if (formXsl == null) {
                formXsl = Config.getProperty("formStylesheet");
            }
            StringBuffer formHtml = XSLTranslator.xslTransform(xmlString, formXsl);
            this.msg.SetOutPrintWriter();
            String contentType = this.msg.getValue("mraldContentType")[0];
            this.msg.setContentType(contentType);
            this.msg.setHeader("Content-Disposition", "inline;");
            PrintWriter out = this.msg.getOutPrintWriter();
            out.println(formHtml);
        }
        catch (IOException mge) {
            throw new WorkflowStepException("IOException in XSLTranslator.execute() " + mge.getMessage());
        }
        catch (MsgObjectException e) {
            throw new WorkflowStepException("MsgObjectException in FormUtils.execute() " + e.getMessage());
        }
    }
}

