/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.util;

public class SqlTemplates {
    private static String ORA_Insert_Trigger = "CREATE TRIGGER <tableName>_Label_Insert AFTER INSERT ON <tableName> FOR EACH ROW BEGIN  INSERT INTO <tableName>_Label VALUES(<insertTriggerPk> 'NOT SET'); END;";
    private static String ORA_Delete_Trigger = "CREATE TRIGGER <tableName>_Label_Delete AFTER DELETE ON <tableName> FOR EACH ROW  BEGIN DELETE FROM <tableName>_Label WHERE <deleteTriggerPks>; END;";
    private static String POSTGRES_Insert_Trigger = "CREATE RULE <tableName>_Label_Insert AS ON INSERT TO <tableName> DO  INSERT INTO <tableName>_Label VALUES(<insertTriggerPk> 'NOT SET') ";
    private static String POSTGRES_Delete_Trigger = "CREATE RULE <tableName>_Label_Delete AS ON DELETE TO <tableName> DO  DELETE FROM <tableName>_Label WHERE <deleteTriggerPks>";

    public static String getInsertTrigger(String database) {
        if (database.startsWith("Oracle")) {
            return ORA_Insert_Trigger;
        }
        if (database.startsWith("PostgreSQL")) {
            return POSTGRES_Insert_Trigger;
        }
        return ORA_Insert_Trigger;
    }

    public static String getDeleteTrigger(String database) {
        if (database.startsWith("Oracle")) {
            return ORA_Delete_Trigger;
        }
        if (database.startsWith("PostgreSQL")) {
            return POSTGRES_Delete_Trigger;
        }
        return ORA_Delete_Trigger;
    }
}

