/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import edu.berkeley.guir.prefuse.util.GeometryLib;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MraldEdgeRenderer
extends ShapeRenderer {
    public static final String EDGE_TYPE = "edgeType";
    protected static final double HALF_PI = 1.5707963267948966;
    protected static final Polygon DEFAULT_ARROW_HEAD = new Polygon(new int[]{0, -4, 4, 0}, new int[]{0, -12, -12, 0}, 4);
    public static final int EDGE_TYPE_LINE = 0;
    public static final int EDGE_TYPE_CURVE = 1;
    public static final int LOOPBACK_CURVE = 2;
    public static final int WEIGHT_TYPE_NONE = 0;
    public static final int WEIGHT_TYPE_LINEAR = 1;
    public static final int WEIGHT_TYPE_LOG = 2;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 1;
    public static final int ALIGNMENT_TOP = 0;
    protected Line2D m_line = new Line2D.Float();
    protected CubicCurve2D m_cubic = new CubicCurve2D.Float();
    protected Arc2D m_arc = new Arc2D.Float();
    protected int m_edgeType = 0;
    protected int m_weightType = 1;
    protected int m_xAlign1 = 2;
    protected int m_yAlign1 = 2;
    protected int m_xAlign2 = 2;
    protected int m_yAlign2 = 2;
    protected int m_width = 1;
    protected int m_curWidth = 1;
    protected Point2D[] m_tmpPoints = new Point2D[2];
    protected Point2D[] m_ctrlPoints = new Point2D[2];
    protected Point2D[] m_isctPoints = new Point2D[2];
    protected String m_weightLabel = "weight";
    protected boolean m_directed = false;
    protected Polygon m_arrowHead = DEFAULT_ARROW_HEAD;
    protected AffineTransform m_arrowTrans = new AffineTransform();
    private static int defaultType = 0;
    private static int loopBackWidth = 70;

    public MraldEdgeRenderer() {
        this.m_tmpPoints[0] = new Point2D.Float();
        this.m_tmpPoints[1] = new Point2D.Float();
        this.m_ctrlPoints[0] = new Point2D.Float();
        this.m_ctrlPoints[1] = new Point2D.Float();
        this.m_isctPoints[0] = new Point2D.Float();
        this.m_isctPoints[1] = new Point2D.Float();
    }

    public String getWeightAttributeName() {
        return this.m_weightLabel;
    }

    public void setWeightAttributeName(String attrName) {
        this.m_weightLabel = attrName;
    }

    public int getWeightType() {
        return this.m_weightType;
    }

    public void setWeightType(int type) {
        this.m_weightType = type;
    }

    public int getRenderType() {
        if (this.m_directed) {
            return 3;
        }
        return 1;
    }

    protected Shape getRawShape(VisualItem item) {
        EdgeItem edge = (EdgeItem)item;
        VisualItem item1 = (VisualItem)edge.getFirstNode();
        VisualItem item2 = (VisualItem)edge.getSecondNode();
        String stype = (String)edge.getVizAttribute(EDGE_TYPE);
        int type = this.m_edgeType;
        if (stype != null) {
            try {
                type = Integer.parseInt(stype);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (item1 == item2) {
            System.out.println("Setting the two points equal");
            this.m_edgeType = type = 2;
        } else {
            this.m_edgeType = defaultType;
        }
        MraldEdgeRenderer.getAlignedPoint(this.m_tmpPoints[0], item1.getRenderer().getBoundsRef(item1), this.m_xAlign1, this.m_yAlign1);
        MraldEdgeRenderer.getAlignedPoint(this.m_tmpPoints[1], item2.getRenderer().getBoundsRef(item2), this.m_xAlign2, this.m_yAlign2);
        double n1x = this.m_tmpPoints[0].getX();
        double n1y = this.m_tmpPoints[0].getY();
        double n2x = this.m_tmpPoints[1].getX();
        double n2y = this.m_tmpPoints[1].getY();
        this.m_curWidth = this.getLineWidth(item);
        switch (type) {
            case 0: {
                this.m_line.setLine(n1x, n1y, n2x, n2y);
                return this.m_line;
            }
            case 1: {
                this.getCurveControlPoints(edge, this.m_ctrlPoints, n1x, n1y, n2x, n2y);
                this.m_cubic.setCurve(n1x, n1y, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), n2x, n2y);
                return this.m_cubic;
            }
            case 2: {
                this.getCurveControlPoints(edge, this.m_ctrlPoints, n1x, n1y, n2x, n2y);
                this.m_arc.setArc(this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), loopBackWidth, loopBackWidth, 0.0, 360.0, 0);
                return this.m_arc;
            }
        }
        throw new IllegalStateException("Unknown edge type");
    }

    public void render(Graphics2D g, VisualItem item) {
        super.render(g, item);
        EdgeItem e = (EdgeItem)item;
        if (e.isDirected()) {
            int width;
            Point2D start = null;
            Point2D end = null;
            String stype = (String)item.getVizAttribute(EDGE_TYPE);
            int type = this.m_edgeType;
            if (stype != null) {
                try {
                    type = Integer.parseInt(stype);
                }
                catch (Exception ex) {
                    System.out.println("MraldEdgeRenderer:" + ex.getMessage());
                }
            }
            switch (type) {
                case 0: {
                    start = this.m_tmpPoints[0];
                    end = this.m_tmpPoints[1];
                    width = this.m_width;
                    break;
                }
                case 1: {
                    start = this.m_ctrlPoints[1];
                    end = this.m_tmpPoints[1];
                    width = 1;
                    break;
                }
                case 2: {
                    start = this.m_ctrlPoints[1];
                    end = this.m_tmpPoints[1];
                    width = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown edge type.");
                }
            }
            VisualItem item2 = (VisualItem)e.getSecondNode();
            Rectangle2D r = item2.getBounds();
            int i = GeometryLib.intersectLineRectangle((Point2D)start, (Point2D)end, (Rectangle2D)r, (Point2D[])this.m_isctPoints);
            if (i > 0) {
                end = this.m_isctPoints[0];
            }
            AffineTransform at = this.getArrowTrans(start, end, width, true);
            float x = (float)(end.getX() + start.getX()) / 2.0f;
            float y = (float)(end.getY() + start.getY()) / 2.0f + 10.0f;
            if (type == 2) {
                x += (float)(loopBackWidth / 2);
                y += (float)(loopBackWidth / 2);
                at = this.getArrowTrans(new Point2D.Double(start.getX(), start.getY()), new Point2D.Double(end.getX() + (double)loopBackWidth, end.getY() + (double)(loopBackWidth / 2)), width, false);
            }
            Shape arrowHead = at.createTransformedShape(this.m_arrowHead);
            String text = item.getAttribute(this.m_weightLabel);
            Color oldCol = g.getColor();
            if (text != null) {
                g.setColor(Color.BLACK);
                g.drawString(text, x, y);
                g.setColor(oldCol);
            }
            g.draw(arrowHead);
            g.fill(arrowHead);
            g.setPaint(item.getFillColor());
            g.fill(arrowHead);
        }
    }

    protected AffineTransform getArrowTrans(Point2D p1, Point2D p2, int width, boolean rotate) {
        this.m_arrowTrans.setToTranslation(p2.getX(), p2.getY());
        if (rotate) {
            this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX()));
        }
        if (width > 1) {
            double scalar = 2.0 * (double)(width - 1) / 4.0 + 1.0;
            this.m_arrowTrans.scale(scalar, scalar);
        }
        return this.m_arrowTrans;
    }

    protected AffineTransform getTransform(VisualItem item) {
        return null;
    }

    public boolean locatePoint(Point2D p, VisualItem item) {
        Shape s = this.getShape(item);
        if (s == null) {
            return false;
        }
        double width = Math.max(2, this.getLineWidth(item));
        double halfWidth = width / 2.0;
        return s.intersects(p.getX() - halfWidth, p.getY() - halfWidth, width, width);
    }

    protected int getLineWidth(VisualItem item) {
        if (this.m_weightType == 0) {
            return this.m_width;
        }
        String wstr = item.getAttribute(this.m_weightLabel);
        if (wstr != null) {
            try {
                double w = Double.parseDouble(wstr);
                if (this.m_weightType == 1) {
                    return (int)Math.round(w);
                }
                if (this.m_weightType == 2) {
                    return Math.max(1, 1 + (int)Math.round(Math.log(w)));
                }
            }
            catch (Exception e) {
                System.err.println("Weight value is not a valid number!");
                e.printStackTrace();
            }
        }
        return this.m_width;
    }

    protected BasicStroke getStroke(VisualItem item) {
        return this.m_curWidth == 1 ? null : new BasicStroke(this.m_curWidth);
    }

    protected void getCurveControlPoints(EdgeItem eitem, Point2D[] cp, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        cp[0].setLocation(x1 + 2.0 * dx / 3.0, y1);
        cp[1].setLocation(x2 - dx / 8.0, y2 - dy / 8.0);
    }

    protected static void getAlignedPoint(Point2D p, Rectangle2D r, int xAlign, int yAlign) {
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        if (xAlign == 2) {
            x += w / 2.0;
        } else if (xAlign == 1) {
            x += w;
        }
        if (yAlign == 2) {
            y += h / 2.0;
        } else if (yAlign == 1) {
            y += h;
        }
        p.setLocation(x, y);
    }

    public int getEdgeType() {
        return this.m_edgeType;
    }

    public void setEdgeType(int type) {
        defaultType = this.m_edgeType = type;
    }

    public int getHorizontalAlignment1() {
        return this.m_xAlign1;
    }

    public int getVerticalAlignment1() {
        return this.m_yAlign1;
    }

    public int getHorizontalAlignment2() {
        return this.m_xAlign2;
    }

    public int getVerticalAlignment2() {
        return this.m_yAlign2;
    }

    public void setHorizontalAlignment1(int align) {
        this.m_xAlign1 = align;
    }

    public void setVerticalAlignment1(int align) {
        this.m_yAlign1 = align;
    }

    public void setHorizontalAlignment2(int align) {
        this.m_xAlign2 = align;
    }

    public void setVerticalAlignment2(int align) {
        this.m_yAlign2 = align;
    }

    public void setWidth(int w) {
        this.m_width = w;
    }
}

