/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mitre.mrald.graphics.AppletComm;
import org.mitre.mrald.graphics.MraldColorChooser;
import org.mitre.mrald.graphics.MraldPalette;
import org.mitre.mrald.graphics.MraldVisual;
import org.mitre.mrald.graphics.SearchPanel;
import org.mitre.mrald.graphics.VisualColorFunction;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.PrintPreview;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MraldPanel
extends JPanel
implements MraldVisual {
    private HashMap<String, Object> attributeValues = new HashMap();
    private ForceSimulator fsim;
    private static float scaleFactor = 1.0f;
    private ArrayList showForces = new ArrayList();
    private ArrayList<JPanel> tabPanels = new ArrayList();
    protected GridBagLayout gridBag = new GridBagLayout();
    private Properties props = new Properties();
    private VisualColorFunction colorFunc;

    public MraldPanel(HashMap<String, Object> initialVals) throws MraldException {
        this.attributeValues = new HashMap<String, Object>(initialVals);
        Color panelColor = Color.WHITE;
        if (this.hasAttribute("PanelColor")) {
            panelColor = (Color)this.getAttribute("PanelColor");
        }
        this.colorFunc = this.getColors();
        this.setBackground(panelColor);
        this.setProperties();
        this.initUI();
        this.addTabPanes();
    }

    @Override
    public void setAttribute(String keyName, Object value) throws MraldException {
        this.attributeValues.put(keyName, value);
    }

    @Override
    public Object getAttribute(String keyName) throws MraldException {
        return this.attributeValues.get(keyName);
    }

    public boolean hasAttribute(String keyName) throws MraldException {
        return this.attributeValues.containsKey(keyName);
    }

    public ColorFunction getColorFunction() {
        return this.colorFunc;
    }

    protected void initUI() throws MraldException {
        this.initTabPanels(2);
        this.setLayout(this.gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        this.setActions();
        if (this.hasAttribute("displayForces")) {
            this.showForces = (ArrayList)this.getAttribute("displayForces");
        }
        Color boxColor = Color.WHITE;
        Box toolBox = this.getToolsBox();
        this.gridBag.setConstraints(toolBox, c);
        this.addToTabPanel(0, toolBox);
        JPanel colorPanel = this.getColorPanel();
        this.gridBag.setConstraints(colorPanel, c);
        this.addToTabPanel(1, colorPanel);
        this.addToTabPanel(1, this.getSaveButton());
        this.addToTabPanel(1, this.getPrintButton());
        SearchPanel searchPanel = (SearchPanel)this.getSearchPanel();
        if (searchPanel != null) {
            this.gridBag.setConstraints(searchPanel, c);
            this.addToTabPanel(0, searchPanel);
        }
        this.add(Box.createHorizontalGlue());
        if (this.hasAttribute("fsim")) {
            this.fsim = (ForceSimulator)this.getAttribute("fsim");
            Force[] forces = this.fsim.getForces();
            for (int i = 0; i < forces.length; ++i) {
                Force f = forces[i];
                String name = f.getClass().getName();
                if (!this.showForces.contains(name = name.substring(name.lastIndexOf(".") + 1))) continue;
                Box v = new Box(1);
                v.setBackground(boxColor);
                for (int j = 0; j < f.getParameterCount(); ++j) {
                    Box viz = this.createObject(f, j);
                    if (viz == null) continue;
                    v.add(viz);
                }
                v.setBorder(BorderFactory.createTitledBorder(name));
                this.gridBag.setConstraints(v, c);
                this.addToTabPanel(0, v);
            }
        }
    }

    private void setProperties() throws MraldException {
        if (this.hasAttribute("settings")) {
            this.props = (Properties)this.getAttribute("settings");
            if (this.props == null) {
                this.props = new Properties();
            }
        } else {
            this.props = new Properties();
        }
    }

    protected void addToTabPanel(int panelNo, Component comp) throws MraldException {
        this.getTabPanel(panelNo).add(comp);
    }

    protected void addTabPanes() throws MraldException {
        JTabbedPane tabPane = new JTabbedPane();
        String[] titles = new String[]{"Tools", "Settings"};
        String title = "";
        for (int i = 0; i < this.tabPanels.size(); ++i) {
            title = titles.length < i ? "Tab" + i : titles[i];
            tabPane.addTab(title, this.tabPanels.get(i));
        }
        this.add(tabPane);
    }

    protected void initTabPanels(int noOfPanels) throws MraldException {
        Color bckColor = this.getBackground();
        if (this.hasAttribute("PanelColor")) {
            bckColor = (Color)this.getAttribute("PanelColor");
        }
        for (int i = 0; i < noOfPanels; ++i) {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(bckColor);
            jPanel.setLayout(this.gridBag);
            this.tabPanels.add(jPanel);
        }
    }

    protected JPanel getTabPanel(int i) throws MraldException {
        if (this.tabPanels.size() < i) {
            throw new MraldException("Cannot get this Tab");
        }
        return this.tabPanels.get(i);
    }

    protected Box getToolsBox() throws MraldException {
        JButton freezeButton = this.getFreezeButton();
        JButton overviewButton = this.getOverviewButton();
        Box a = new Box(0);
        a.add(freezeButton);
        a.add(overviewButton);
        a.setBorder(BorderFactory.createTitledBorder("Tools"));
        return a;
    }

    private VisualColorFunction getColors() throws MraldException {
        if (this.hasAttribute("settings")) {
            VisualColorFunction colorFunc = (VisualColorFunction)((Object)this.getAttribute("colorSet"));
            if (this.hasAttribute("settings")) {
                colorFunc.loadColors((Properties)this.getAttribute("settings"));
            }
            return colorFunc;
        }
        if (this.hasAttribute("colorSet")) {
            VisualColorFunction colorFunc = (VisualColorFunction)((Object)this.getAttribute("colorSet"));
            return colorFunc;
        }
        return new VisualColorFunction();
    }

    private JPanel getColorPanel() throws MraldException {
        HashMap<Object, Object> coloringItems = new HashMap();
        int rows = 1;
        coloringItems = this.colorFunc.getColors();
        if (!this.hasAttribute("forces")) {
            System.out.println("No Forces List found");
            return null;
        }
        MraldPalette palette = new MraldPalette(this.getBackground(), coloringItems.size(), rows, coloringItems);
        palette.addPropertyChangeListener(new ColorChooserChange());
        palette.putClientProperty("colorSet", (Object)this.colorFunc);
        palette.putClientProperty("forces", this.getAttribute("forces"));
        return palette;
    }

    private JPanel getSearchPanel() throws MraldException {
        if (!this.hasAttribute("registry")) {
            return null;
        }
        if (!this.hasAttribute("PanelColor")) {
            ItemRegistry registry = (ItemRegistry)this.getAttribute("registry");
            SearchPanel searchPanel = new SearchPanel(registry);
            return searchPanel;
        }
        Color backColor = (Color)this.getAttribute("PanelColor");
        ItemRegistry registry = (ItemRegistry)this.getAttribute("registry");
        SearchPanel searchPanel = new SearchPanel(backColor, registry);
        return searchPanel;
    }

    private JButton getOverviewButton() throws MraldException {
        JButton but = new JButton("Overview");
        but.putClientProperty("registry", this.getAttribute("registry"));
        but.putClientProperty("display", this.getAttribute("display"));
        but.putClientProperty("hide", new Boolean(true));
        but.addActionListener((ShowOverviewAction)this.getAttribute("overview"));
        return but;
    }

    private JButton getSaveButton() throws MraldException {
        JButton but = new JButton("Save");
        but.putClientProperty("registry", this.getAttribute("registry"));
        but.putClientProperty("colorSet", this.getAttribute("colorSet"));
        but.addActionListener((SaveAllAction)this.getAttribute("save"));
        return but;
    }

    private JButton getPrintButton() throws MraldException {
        JButton but = new JButton("Print");
        but.putClientProperty("registry", this.getAttribute("registry"));
        but.putClientProperty("display", this.getAttribute("display"));
        but.addActionListener((PrintAllAction)this.getAttribute("print"));
        return but;
    }

    private JButton getFreezeButton() throws MraldException {
        JButton but = new JButton("Freeze");
        but.putClientProperty("registry", this.getAttribute("registry"));
        but.putClientProperty("frozen", new Boolean(true));
        but.addActionListener((FreezeAction)this.getAttribute("freeze"));
        return but;
    }

    private void setActions() throws MraldException {
        this.setAttribute("action", new ForceConstantAction());
        this.setAttribute("change", new ForceChange());
        this.setAttribute("freeze", new FreezeAction());
        this.setAttribute("chooser", new ColorChooser());
        this.setAttribute("overview", new ShowOverviewAction());
        this.setAttribute("save", new SaveAllAction());
        this.setAttribute("print", new PrintAllAction());
    }

    private Box createObject(Force f, int param) throws MraldException {
        Box h = new Box(0);
        float curVal = f.getParameter(param);
        String labelVal = f.getParameterName(param);
        if (!this.showForces.contains(labelVal)) {
            return null;
        }
        if (this.hasAttribute(f.getParameterName(param))) {
            labelVal = (String)this.getAttribute(f.getParameterName(param));
        }
        JLabel label = new JLabel(labelVal);
        label.setPreferredSize(new Dimension(200, 20));
        label.setMaximumSize(new Dimension(200, 20));
        String objectType = "Slider";
        JComponent newObject = null;
        scaleFactor = -1.0f * curVal;
        if (objectType.equals("Slider")) {
            newObject = new JSlider(-1000, 1000, new Float(curVal / scaleFactor).intValue());
            newObject.setPreferredSize(new Dimension(400, 20));
            newObject.setMaximumSize(new Dimension(400, 20));
            ((JSlider)newObject).addChangeListener((ForceChange)this.getAttribute("change"));
        } else if (objectType.equals("TextField")) {
            newObject = new JTextField(String.valueOf(curVal));
            newObject.setPreferredSize(new Dimension(200, 20));
            newObject.setMaximumSize(new Dimension(200, 20));
            ((JTextField)newObject).addActionListener((ForceConstantAction)this.getAttribute("action"));
        }
        newObject.putClientProperty("force", f);
        newObject.putClientProperty("param", new Integer(param));
        h.add(label);
        h.add(Box.createHorizontalStrut(10));
        h.add(Box.createHorizontalGlue());
        h.add(newObject);
        h.setPreferredSize(new Dimension(500, 30));
        h.setMaximumSize(new Dimension(500, 30));
        return h;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("Highlight")) {
            // empty if block
        }
    }

    private class ShowOverviewAction
    extends AbstractAction {
        private ShowOverviewAction() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JButton but = (JButton)arg0.getSource();
            ItemRegistry registry = (ItemRegistry)but.getClientProperty("registry");
            Display display = (Display)but.getClientProperty("display");
            boolean hide = (Boolean)but.getClientProperty("hide");
            but.putClientProperty("hide", new Boolean(!hide));
            if (registry != null && display != null) {
                if (hide) {
                    but.setText("Hide");
                    Display overview = new Display(registry);
                    overview.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                    overview.setSize(200, 200);
                    overview.zoom((Point2D)new Point2D.Float(100.0f, 100.0f), 0.2);
                    int compNo = display.getComponentCount();
                    but.putClientProperty("compNo", new Integer(compNo));
                    display.add((Component)overview, compNo);
                } else {
                    but.setText("Overview");
                    Display overview = new Display(registry);
                    overview.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                    overview.setSize(200, 200);
                    overview.zoom((Point2D)new Point2D.Float(100.0f, 100.0f), 0.2);
                    Integer compNoInt = (Integer)but.getClientProperty("compNo");
                    if (compNoInt != null) {
                        int compNo = compNoInt;
                        display.remove(compNo);
                    }
                }
            } else {
                System.out.println("Could not find property registry or dipslay");
            }
        }
    }

    private class SaveAllAction
    extends AbstractAction {
        private SaveAllAction() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                JButton but = (JButton)arg0.getSource();
                VisualColorFunction colorSet = (VisualColorFunction)((Object)but.getClientProperty("colorSet"));
                colorSet.saveColors(MraldPanel.this.props);
                ByteArrayOutputStream fileOut = new ByteArrayOutputStream();
                MraldPanel.this.props.store(fileOut, "test");
                System.out.println("Save All. About to upload file");
                URL baseURL = null;
                if (MraldPanel.this.hasAttribute("baseURL")) {
                    baseURL = (URL)MraldPanel.this.getAttribute("baseURL");
                }
                AppletComm.uploadFile(fileOut, baseURL, "FileUtil.jsp", "graphics/settings.properties");
                System.out.println("Save Properties ");
            }
            catch (Exception e) {
                System.out.println("Save error: " + e.getMessage());
            }
        }
    }

    private class PrintAllAction
    extends AbstractAction {
        private PrintAllAction() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                JButton but = (JButton)arg0.getSource();
                System.out.println("Printing this ");
                Display printView = (Display)but.getClientProperty("display");
                printView.stopEditing();
                int compNo = 0;
                compNo = printView.getComponents().length;
                System.out.println("Mrald Panel Print - no of components " + compNo);
                Component[] components = new Component[]{printView};
                new PrintPreview(components, " preview all");
            }
            catch (Exception e) {
                System.out.println("Save error: " + e.getMessage());
            }
        }
    }

    private class FreezeAction
    extends AbstractAction {
        private FreezeAction() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JButton but = (JButton)arg0.getSource();
            ItemRegistry registry = (ItemRegistry)but.getClientProperty("registry");
            boolean frozen = (Boolean)but.getClientProperty("frozen");
            but.putClientProperty("frozen", new Boolean(!frozen));
            if (registry != null) {
                Iterator items = registry.getItems();
                if (frozen) {
                    but.setText("Unfreeze");
                } else {
                    but.setText("Freeze");
                }
                while (items.hasNext()) {
                    VisualItem vizItem = (VisualItem)items.next();
                    vizItem.setFixed(frozen);
                }
            } else {
                System.out.println("Could not find property registry");
            }
        }
    }

    private class ColorChooserChange
    implements PropertyChangeListener {
        private ColorChooserChange() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JPanel palette = (JPanel)e.getSource();
            VisualColorFunction colorSet = (VisualColorFunction)((Object)palette.getClientProperty("colorSet"));
            if (colorSet != null) {
                if (colorSet.hasType(e.getPropertyName())) {
                    colorSet.setColor(e.getPropertyName(), (Color)e.getNewValue());
                }
            } else {
                System.out.println("ColorChooserChange. In properyChange: ColorSet is null");
            }
            try {
                MraldPanel.this.setAttribute("colorSet", (Object)colorSet);
            }
            catch (MraldException me) {
                System.out.println("Error in ColorCHooserCHange:" + me.getMessage() + " : " + me.getStackTrace());
            }
        }
    }

    private class ColorChooser
    extends AbstractAction {
        private ColorChooser() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JButton but = (JButton)arg0.getSource();
            Color c = (Color)but.getClientProperty("color");
            HashMap items = (HashMap)but.getClientProperty("setColors");
            new MraldColorChooser(c, items);
            MraldColorChooser.main(new String[0]);
        }
    }

    public class ForceChange
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            float val = 0.0f;
            if (!source.getValueIsAdjusting()) {
                val = (float)(source.getValue() / 50) * scaleFactor;
                Force f = (Force)source.getClientProperty("force");
                Integer param = (Integer)source.getClientProperty("param");
                f.setParameter(param.intValue(), val);
            }
        }
    }

    private class ForceConstantAction
    extends AbstractAction {
        private ForceConstantAction() {
        }

        public void actionPerformed(ActionEvent arg0) {
            JTextField text = (JTextField)arg0.getSource();
            float val = Float.parseFloat(text.getText());
            Force f = (Force)text.getClientProperty("force");
            Integer param = (Integer)text.getClientProperty("param");
            f.setParameter(param.intValue(), val);
        }
    }
}

