/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMetaData {
    private Set<Link> linkList = new HashSet<Link>();
    private ArrayList<TableMetaData> tableMetaData;
    private String[] originalTables;
    private Properties dbProps;
    private String dbVersion;
    private State state;

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("DBMetaData for data source \n");
        ret.append(this.dbProps.toString());
        ret.append("\nNumber of tables: ");
        ret.append(this.tableMetaData.size());
        return ret.toString();
    }

    public DBMetaData() {
        this.tableMetaData = new ArrayList();
        this.dbProps = new Properties();
        this.state = State.NotInitialized;
    }

    public void setState(State s) {
        this.state = s;
    }

    public DBMetaData(Properties props) {
        this.dbProps = props;
        this.tableMetaData = new ArrayList();
        this.state = State.NotInitialized;
    }

    public String[] getOriginalTables() {
        return this.originalTables;
    }

    public State getState() {
        return this.state;
    }

    public void setOriginalTables(String[] originalTables) {
        this.originalTables = originalTables;
    }

    public Collection<TableMetaData> getAllTableMetaData() {
        return this.tableMetaData;
    }

    public Set getLinkList() {
        return this.linkList;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void addLink(Link newLink) {
        this.linkList.add(newLink);
    }

    public void addLinks(Set<Link> newLinks) {
        Iterator<Link> linkIter = newLinks.iterator();
        while (linkIter.hasNext()) {
            this.linkList.add(linkIter.next());
        }
    }

    public void setLinkList(Set<Link> links) {
        this.linkList = links;
    }

    public void setDbVersion(String product, String productVersion) {
        this.dbVersion = product + " " + productVersion;
    }

    public TableMetaData getTableMetaData(String tableName) {
        for (int i = 0; i < this.tableMetaData.size(); ++i) {
            TableMetaData md = this.tableMetaData.get(i);
            if (!md.getName().equals(tableName)) continue;
            return md;
        }
        return null;
    }

    public TableMetaData getTableMetaDataNoCase(String tableName) {
        tableName = tableName.toUpperCase();
        for (int i = 0; i < this.tableMetaData.size(); ++i) {
            TableMetaData md = this.tableMetaData.get(i);
            if (!md.getName().toUpperCase().equals(tableName)) continue;
            return md;
        }
        return null;
    }

    public Link getFKLinkData(String tableName, String fieldName) {
        for (Link link : this.linkList) {
            if (!link.getFtable().equals(tableName) || !link.getFcolumn().equals(fieldName)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getPKLinkData(String tableName) {
        Iterator<Link> linkIter = this.linkList.iterator();
        ArrayList<Link> links = new ArrayList<Link>();
        while (linkIter.hasNext()) {
            Link link = linkIter.next();
            if (!link.getPtable().equals(tableName) || links.contains(link)) continue;
            links.add(link);
        }
        return links;
    }

    public ArrayList getLinks(String table1, String table2) throws MraldException {
        Iterator<Link> linkIter = this.linkList.iterator();
        ArrayList<Link> links = new ArrayList<Link>();
        while (linkIter.hasNext()) {
            Link link = linkIter.next();
            if (link.getPtable().equals(table1) && link.getFtable().equals(table2)) {
                links.add(link);
                continue;
            }
            if (!link.getPtable().equals(table2) || !link.getFtable().equals(table1)) continue;
            links.add(link);
        }
        if (links.size() == 0) {
            throw new MraldException("The tables selected in the Drop Downs are not linked.");
        }
        return links;
    }

    public void addTableMetaData(TableMetaData addee) {
        if (!this.tableMetaData.contains(addee)) {
            this.tableMetaData.add(addee);
        }
    }

    public static HashMap setLinks(DBMetaData md) {
        Set linkList = md.getLinkList();
        Iterator linkIter = linkList.iterator();
        HashMap<String, ArrayList> keysMap = new HashMap<String, ArrayList>();
        while (linkIter.hasNext()) {
            ArrayList keys;
            ArrayList keys2;
            Link link = (Link)linkIter.next();
            String fTable = link.getFtable();
            if (!keysMap.containsKey(fTable)) {
                keys2 = new ArrayList();
                keys2.add(link);
                keysMap.put(fTable, keys2);
            } else {
                keys2 = (ArrayList)keysMap.get(fTable);
                keys2.add(link);
                keysMap.put(fTable, keys2);
            }
            String pTable = link.getPtable();
            if (!keysMap.containsKey(pTable)) {
                keys = new ArrayList();
                keys.add(link);
                keysMap.put(pTable, keys);
                continue;
            }
            keys = (ArrayList)keysMap.get(pTable);
            keys.add(link);
            keysMap.put(pTable, keys);
        }
        return keysMap;
    }

    public static boolean isFkey(String table, String column, HashMap keysMap) {
        if (keysMap.containsKey(table)) {
            ArrayList links = (ArrayList)keysMap.get(table);
            for (int i = 0; i < links.size(); ++i) {
                Link link = (Link)links.get(i);
                if (link.getFcolumn().equals(column)) {
                    return true;
                }
                if (!link.getPcolumn().equals(column)) continue;
                return true;
            }
        }
        return false;
    }

    public Properties getDbProps() {
        return this.dbProps;
    }

    public void setDbProps(Properties props) {
        this.dbProps = props;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NotInitialized,
        Loading,
        Loaded,
        Broken;

    }
}

