/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public class FileUtils {
    public void copyFile(File sourceFile, File destFile) throws FileNotFoundException, IOException {
        int len;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
        in = null;
        out = null;
    }

    public void backupFile(String sourceFilename, String backupFilename) throws IOException {
        boolean created;
        String backupDir = backupFilename.substring(0, backupFilename.lastIndexOf("/"));
        if (!new File(backupDir).exists() && !(created = new File(backupDir).mkdirs())) {
            throw new IOException("Couldn't create the directory \"" + backupDir + "\".  Check your file system, though, some intermediate directories may have been created");
        }
        File backupFile = new File(backupFilename);
        File sourcefile = new File(sourceFilename);
        this.copyFile(sourcefile, backupFile);
    }

    @Deprecated
    public void uploadFile(HttpServletRequest req, User user) throws MraldException, FileUploadException, IOException, Exception {
        String itemName;
        FileItem fileSetItem;
        if (!FileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new MraldException("The supplied request did not come from a multipart request - there can't be any file buried in here.");
        }
        DiskFileUpload upload = new DiskFileUpload();
        List items = upload.parseRequest(req);
        Iterator iter = items.iterator();
        String fileName = "";
        while (iter.hasNext()) {
            fileSetItem = (FileItem)iter.next();
            itemName = fileSetItem.getFieldName();
            if (!itemName.startsWith("fileName")) continue;
            fileName = fileSetItem.get().toString();
        }
        items.iterator();
        while (iter.hasNext()) {
            fileSetItem = (FileItem)iter.next();
            itemName = fileSetItem.getFieldName();
            if (!itemName.startsWith("settings")) continue;
            String dirFileName = Config.getProperty("BasePath");
            File fileFinalLocation = new File(dirFileName + "/" + fileName);
            fileSetItem.write(fileFinalLocation);
        }
    }
}

