/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.List;

public class AggregateItem
extends NodeItem {
    private double m_orientation = 0.0;
    private double m_startOrientation = 0.0;
    private double m_endOrientation = 0.0;
    private int m_aggrSize;
    private NodeItem m_nitem;

    public void init(ItemRegistry itemRegistry, String string, Entity entity) {
        if (entity != null && !(entity instanceof Node)) {
            throw new IllegalArgumentException("AggregateItem can only represent an Entity of type Node.");
        }
        super.init(itemRegistry, string, entity);
        VisualItem visualItem = null;
        if (entity instanceof Node) {
            visualItem = this.m_registry.getNodeItem((Node)entity);
        } else if (entity instanceof Edge) {
            visualItem = this.m_registry.getEdgeItem((Edge)entity);
        }
        if (visualItem != null) {
            this.setDOI(visualItem.getDOI());
            this.setStartLocation(visualItem.getStartLocation());
            this.setLocation(visualItem.getLocation());
            this.setEndLocation(visualItem.getEndLocation());
            this.setStartSize(visualItem.getStartSize());
            this.setSize(visualItem.getSize());
            this.setEndSize(visualItem.getEndSize());
            this.setFont(visualItem.getFont());
        }
    }

    public void clear() {
        super.clear();
        this.m_aggrSize = 0;
        this.m_orientation = 0.0;
        this.m_startOrientation = 0.0;
        this.m_endOrientation = 0.0;
        this.m_location.setLocation(0.0, 0.0);
        this.m_startLocation.setLocation(0.0, 0.0);
        this.m_endLocation.setLocation(0.0, 0.0);
    }

    public List getEntities() {
        return this.m_registry.getEntities(this);
    }

    public Entity getEntity(int n) {
        return (Entity)this.m_registry.getEntities(this).get(n);
    }

    public NodeItem getNodeItem() {
        return this.m_nitem;
    }

    public void setNodeItem(NodeItem nodeItem) {
        this.m_nitem = nodeItem;
    }

    public int getAggregateSize() {
        return this.m_aggrSize;
    }

    public void setAggregateSize(int n) {
        this.m_aggrSize = n;
    }

    public double getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(double d) {
        this.m_orientation = d;
    }

    public double getEndOrientation() {
        return this.m_endOrientation;
    }

    public double getStartOrientation() {
        return this.m_startOrientation;
    }

    public void setEndOrientation(double d) {
        this.m_endOrientation = d;
    }

    public void setStartOrientation(double d) {
        this.m_startOrientation = d;
    }
}

