/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemFactory;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.collections.CompositeItemIterator;
import edu.berkeley.guir.prefuse.collections.DefaultItemComparator;
import edu.berkeley.guir.prefuse.collections.VisibleItemIterator;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.event.ItemRegistryListener;
import edu.berkeley.guir.prefuse.event.RegistryEventMulticaster;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ItemRegistry {
    public static final String DEFAULT_NODE_CLASS = "node";
    public static final String DEFAULT_EDGE_CLASS = "edge";
    public static final String DEFAULT_AGGR_CLASS = "aggregate";
    public static final int DEFAULT_MAX_ITEMS = 10000;
    public static final int DEFAULT_MAX_DIRTY = 1;
    protected Graph m_backingGraph;
    protected Graph m_filteredGraph;
    protected List m_displays;
    protected FocusManager m_fmanager;
    protected ItemFactory m_ifactory;
    protected RendererFactory m_rfactory;
    protected List m_entryList;
    protected Map m_entryMap;
    protected Map m_entityMap;
    protected int m_size;
    protected Comparator m_comparator;
    protected ItemRegistryListener m_registryListener;
    protected FocusListener m_focusListener;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$NodeItem;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$EdgeItem;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$AggregateItem;

    public ItemRegistry(Graph graph) {
        this(graph, true);
    }

    public ItemRegistry(Graph graph, boolean bl) {
        this.m_backingGraph = graph;
        this.m_displays = new ArrayList();
        this.m_fmanager = new FocusManager();
        try {
            this.m_ifactory = new ItemFactory();
            this.m_rfactory = new DefaultRendererFactory();
            this.m_entryList = new LinkedList();
            this.m_entryMap = new HashMap();
            this.m_entityMap = new HashMap();
            this.m_comparator = new DefaultItemComparator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.defaultInitialization();
        }
    }

    private synchronized void defaultInitialization() {
        this.addItemClass(DEFAULT_NODE_CLASS, class$edu$berkeley$guir$prefuse$NodeItem == null ? (class$edu$berkeley$guir$prefuse$NodeItem = ItemRegistry.class$("edu.berkeley.guir.prefuse.NodeItem")) : class$edu$berkeley$guir$prefuse$NodeItem);
        this.addItemClass(DEFAULT_EDGE_CLASS, class$edu$berkeley$guir$prefuse$EdgeItem == null ? (class$edu$berkeley$guir$prefuse$EdgeItem = ItemRegistry.class$("edu.berkeley.guir.prefuse.EdgeItem")) : class$edu$berkeley$guir$prefuse$EdgeItem);
        this.addItemClass(DEFAULT_AGGR_CLASS, class$edu$berkeley$guir$prefuse$AggregateItem == null ? (class$edu$berkeley$guir$prefuse$AggregateItem = ItemRegistry.class$("edu.berkeley.guir.prefuse.AggregateItem")) : class$edu$berkeley$guir$prefuse$AggregateItem);
    }

    public synchronized void addItemClass(String string, Class clazz) {
        this.addItemClass(string, clazz, 1, 10000);
    }

    public synchronized void addItemClass(String string, Class clazz, int n) {
        this.addItemClass(string, clazz, n, 10000);
    }

    public synchronized void addItemClass(String string, Class clazz, int n, int n2) {
        ItemEntry itemEntry = new ItemEntry(string, clazz, n);
        this.m_entryList.add(itemEntry);
        this.m_entryMap.put(string, itemEntry);
        this.m_ifactory.addItemClass(string, clazz, n2);
    }

    public synchronized Graph getGraph() {
        return this.m_backingGraph;
    }

    public synchronized void setGraph(Graph graph) {
        this.m_backingGraph = graph;
    }

    public synchronized Graph getFilteredGraph() {
        return this.m_filteredGraph;
    }

    public synchronized void setFilteredGraph(Graph graph) {
        this.m_filteredGraph = graph;
    }

    public synchronized void addDisplay(Display display) {
        if (!this.m_displays.contains(display)) {
            this.m_displays.add(display);
        }
    }

    public synchronized boolean removeDisplay(Display display) {
        boolean bl = this.m_displays.remove(display);
        if (bl) {
            display.setItemRegistry(null);
        }
        return bl;
    }

    public synchronized Display getDisplay(int n) {
        return (Display)this.m_displays.get(n);
    }

    public synchronized int getDisplayCount() {
        return this.m_displays.size();
    }

    public synchronized void repaint() {
        Iterator iterator = this.m_displays.iterator();
        while (iterator.hasNext()) {
            ((Display)iterator.next()).repaint();
        }
    }

    public synchronized List getDisplays() {
        ArrayList arrayList = new ArrayList(this.m_displays.size());
        arrayList.addAll(this.m_displays);
        return arrayList;
    }

    public synchronized FocusManager getFocusManager() {
        return this.m_fmanager;
    }

    public synchronized FocusSet getDefaultFocusSet() {
        return this.m_fmanager.getDefaultFocusSet();
    }

    public synchronized RendererFactory getRendererFactory() {
        return this.m_rfactory;
    }

    public synchronized void setRendererFactory(RendererFactory rendererFactory) {
        this.m_rfactory = rendererFactory;
    }

    public synchronized Comparator getItemComparator() {
        return this.m_comparator;
    }

    public synchronized void setItemComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public synchronized ItemFactory getItemFactory() {
        return this.m_ifactory;
    }

    public synchronized int size(String string) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        return itemEntry == null ? -1 : itemEntry.itemList.size();
    }

    public synchronized int size() {
        return this.m_size;
    }

    public synchronized void garbageCollect(String string) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        if (itemEntry == null) {
            throw new IllegalArgumentException("The input string must be a recognized item class!");
        }
        this.garbageCollect(itemEntry);
    }

    public synchronized void garbageCollect(ItemEntry itemEntry) {
        itemEntry.modified = true;
        Iterator iterator = itemEntry.itemList.iterator();
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            int n = visualItem.getDirty() + 1;
            visualItem.setDirty(n);
            if (itemEntry.maxDirty > -1 && n > itemEntry.maxDirty) {
                iterator.remove();
                this.removeItem(itemEntry, visualItem, false);
                continue;
            }
            if (n <= 1) continue;
            visualItem.setVisible(false);
        }
    }

    public synchronized void garbageCollectNodes() {
        this.garbageCollect(DEFAULT_NODE_CLASS);
    }

    public synchronized void garbageCollectEdges() {
        this.garbageCollect(DEFAULT_EDGE_CLASS);
    }

    public synchronized void garbageCollectAggregates() {
        this.garbageCollect(DEFAULT_AGGR_CLASS);
    }

    public synchronized void clear() {
        Iterator iterator = this.m_entryList.iterator();
        while (iterator.hasNext()) {
            this.clear((ItemEntry)iterator.next());
        }
    }

    private synchronized void clear(ItemEntry itemEntry) {
        itemEntry.modified = true;
        while (itemEntry.itemList.size() > 0) {
            VisualItem visualItem = (VisualItem)itemEntry.itemList.get(0);
            this.removeItem(itemEntry, visualItem, true);
        }
    }

    private void sortAll() {
        Iterator iterator = this.m_entryList.iterator();
        while (iterator.hasNext()) {
            ItemEntry itemEntry = (ItemEntry)iterator.next();
            if (!itemEntry.modified) continue;
            Collections.sort(itemEntry.itemList, this.m_comparator);
            itemEntry.modified = false;
        }
    }

    public synchronized Iterator getItems(boolean bl) {
        this.sortAll();
        return new CompositeItemIterator(this.m_entryList, this.m_comparator, bl, false);
    }

    public synchronized Iterator getItems() {
        this.sortAll();
        return new CompositeItemIterator(this.m_entryList, this.m_comparator, true, false);
    }

    public synchronized Iterator getItemsReversed() {
        this.sortAll();
        return new CompositeItemIterator(this.m_entryList, this.m_comparator, true, true);
    }

    public synchronized Iterator getItems(String string, boolean bl) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        if (itemEntry != null) {
            if (itemEntry.modified) {
                Collections.sort(itemEntry.itemList, this.m_comparator);
                itemEntry.modified = false;
            }
            if (bl) {
                return new VisibleItemIterator(itemEntry.itemList, false);
            }
            return itemEntry.itemList.iterator();
        }
        throw new IllegalArgumentException("The input string must be a recognized item class!");
    }

    public synchronized void touch(String string) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        if (itemEntry == null) {
            throw new IllegalArgumentException("The input string must be a recognized item class!");
        }
        itemEntry.modified = true;
    }

    public synchronized void touchNodeItems() {
        this.touch(DEFAULT_NODE_CLASS);
    }

    public synchronized void touchEdgeItems() {
        this.touch(DEFAULT_EDGE_CLASS);
    }

    public synchronized void touchAggregateItems() {
        this.touch(DEFAULT_AGGR_CLASS);
    }

    public synchronized Iterator getNodeItems() {
        return this.getItems(DEFAULT_NODE_CLASS, true);
    }

    public synchronized Iterator getNodeItems(boolean bl) {
        return this.getItems(DEFAULT_NODE_CLASS, bl);
    }

    public synchronized Iterator getEdgeItems() {
        return this.getItems(DEFAULT_EDGE_CLASS, true);
    }

    public synchronized Iterator getEdgeItems(boolean bl) {
        return this.getItems(DEFAULT_EDGE_CLASS, bl);
    }

    public synchronized Iterator getAggregateItems() {
        return this.getItems(DEFAULT_AGGR_CLASS, true);
    }

    public synchronized Iterator getAggregateItems(boolean bl) {
        return this.getItems(DEFAULT_AGGR_CLASS, bl);
    }

    public synchronized Entity getEntity(VisualItem visualItem) {
        Object v = this.m_entityMap.get(visualItem);
        if (v == null) {
            return null;
        }
        if (v instanceof Entity) {
            return (Entity)v;
        }
        return (Entity)((List)v).get(0);
    }

    public synchronized List getEntities(VisualItem visualItem) {
        LinkedList linkedList;
        Object v = this.m_entityMap.get(visualItem);
        if (v instanceof Entity) {
            linkedList = new LinkedList();
            linkedList.add(v);
        } else {
            linkedList = (LinkedList)v;
        }
        return linkedList;
    }

    public synchronized boolean isVisible(Node node) {
        NodeItem nodeItem = this.getNodeItem(node);
        return nodeItem != null && nodeItem.isVisible();
    }

    public synchronized VisualItem getItem(String string, Entity entity, boolean bl, boolean bl2) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        if (itemEntry != null) {
            VisualItem visualItem = (VisualItem)itemEntry.itemMap.get(entity);
            if (bl && visualItem == null) {
                visualItem = this.m_ifactory.getItem(string);
                visualItem.init(this, string, entity);
                this.addItem(itemEntry, entity, visualItem);
            }
            if (bl2 && visualItem instanceof NodeItem) {
                ((NodeItem)visualItem).removeAllNeighbors();
            }
            if (bl) {
                visualItem.setDirty(0);
                visualItem.setVisible(true);
            }
            return visualItem;
        }
        throw new IllegalArgumentException("The input string must be a recognized item class!");
    }

    public synchronized NodeItem getNodeItem(Node node) {
        return (NodeItem)this.getItem(DEFAULT_NODE_CLASS, node, false, false);
    }

    public synchronized NodeItem getNodeItem(Node node, boolean bl) {
        return (NodeItem)this.getItem(DEFAULT_NODE_CLASS, node, bl, false);
    }

    public synchronized NodeItem getNodeItem(Node node, boolean bl, boolean bl2) {
        return (NodeItem)this.getItem(DEFAULT_NODE_CLASS, node, bl, bl2);
    }

    public synchronized EdgeItem getEdgeItem(Edge edge) {
        return (EdgeItem)this.getItem(DEFAULT_EDGE_CLASS, edge, false, false);
    }

    public synchronized EdgeItem getEdgeItem(Edge edge, boolean bl) {
        return (EdgeItem)this.getItem(DEFAULT_EDGE_CLASS, edge, bl, false);
    }

    public synchronized AggregateItem getAggregateItem(Entity entity) {
        return (AggregateItem)this.getItem(DEFAULT_AGGR_CLASS, entity, false, false);
    }

    public synchronized AggregateItem getAggregateItem(Entity entity, boolean bl) {
        return (AggregateItem)this.getItem(DEFAULT_AGGR_CLASS, entity, bl, false);
    }

    public synchronized AggregateItem getAggregateItem(Entity entity, boolean bl, boolean bl2) {
        return (AggregateItem)this.getItem(DEFAULT_AGGR_CLASS, entity, bl, bl2);
    }

    public synchronized void addMapping(Entity entity, VisualItem visualItem) {
        String string = visualItem.getItemClass();
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(string);
        if (itemEntry == null) {
            throw new IllegalArgumentException("The input string must be a recognized item class!");
        }
        this.addMapping(itemEntry, entity, visualItem);
    }

    protected synchronized void addMapping(ItemEntry itemEntry, Entity entity, VisualItem visualItem) {
        itemEntry.itemMap.put(entity, visualItem);
        if (this.m_entityMap.containsKey(visualItem)) {
            LinkedList<Entity> linkedList;
            Object v = this.m_entityMap.get(visualItem);
            if (v instanceof List) {
                linkedList = (LinkedList<Entity>)v;
            } else {
                linkedList = new LinkedList<Entity>();
                linkedList.add((Entity)v);
            }
            linkedList.add(entity);
            this.m_entityMap.put(visualItem, linkedList);
        } else {
            this.m_entityMap.put(visualItem, entity);
        }
    }

    public synchronized void removeMappings(VisualItem visualItem) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(visualItem.getItemClass());
        if (itemEntry == null) {
            throw new IllegalArgumentException("Didn't recognize the item's item class.");
        }
        this.removeMappings(itemEntry, visualItem);
    }

    protected synchronized void removeMappings(ItemEntry itemEntry, VisualItem visualItem) {
        if (this.m_entityMap.containsKey(visualItem)) {
            Object v = this.m_entityMap.get(visualItem);
            this.m_entityMap.remove(visualItem);
            if (v instanceof Entity) {
                itemEntry.itemMap.remove(v);
            } else {
                Iterator iterator = ((List)v).iterator();
                while (iterator.hasNext()) {
                    itemEntry.itemMap.remove(iterator.next());
                }
            }
        }
    }

    protected synchronized void addItem(ItemEntry itemEntry, Entity entity, VisualItem visualItem) {
        this.addItem(itemEntry, visualItem);
        this.addMapping(itemEntry, entity, visualItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItem(ItemEntry itemEntry, VisualItem visualItem) {
        ItemRegistry itemRegistry = this;
        synchronized (itemRegistry) {
            itemEntry.itemList.add(visualItem);
            itemEntry.modified = true;
            ++this.m_size;
        }
        if (this.m_registryListener != null) {
            this.m_registryListener.registryItemAdded(visualItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeItem(ItemEntry itemEntry, VisualItem visualItem, boolean bl) {
        ItemRegistry itemRegistry = this;
        synchronized (itemRegistry) {
            this.removeMappings(itemEntry, visualItem);
            if (bl) {
                itemEntry.itemList.remove(visualItem);
            }
            --this.m_size;
        }
        if (this.m_registryListener != null) {
            this.m_registryListener.registryItemRemoved(visualItem);
        }
        itemRegistry = this;
        synchronized (itemRegistry) {
            this.m_ifactory.reclaim(visualItem);
        }
    }

    public synchronized void removeItem(VisualItem visualItem) {
        ItemEntry itemEntry = (ItemEntry)this.m_entryMap.get(visualItem.getItemClass());
        if (itemEntry == null) {
            throw new IllegalArgumentException("Didn't recognize the item's item class.");
        }
        this.removeItem(itemEntry, visualItem, true);
    }

    public synchronized void addItemRegistryListener(ItemRegistryListener itemRegistryListener) {
        this.m_registryListener = RegistryEventMulticaster.add(this.m_registryListener, itemRegistryListener);
    }

    public synchronized void removeItemRegistryListener(ItemRegistryListener itemRegistryListener) {
        this.m_registryListener = RegistryEventMulticaster.remove(this.m_registryListener, itemRegistryListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ItemEntry {
        public boolean modified;
        public int maxDirty;
        public Class type;
        public String name;
        public List itemList;
        public Map itemMap;

        ItemEntry(String string, Class clazz, int n) {
            try {
                this.name = string;
                this.type = clazz;
                this.itemList = new LinkedList();
                this.itemMap = new HashMap();
                this.modified = false;
                this.maxDirty = n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public List getItemList() {
            return this.itemList;
        }
    }
}

