/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.Iterator;

public class GraphFilter
extends Filter {
    public static final String[] ITEM_CLASSES = new String[]{"node", "edge"};
    protected boolean m_edgesVisible;

    public GraphFilter() {
        this(true, true);
    }

    public GraphFilter(boolean bl) {
        this(bl, true);
    }

    public GraphFilter(boolean bl, boolean bl2) {
        super(ITEM_CLASSES, bl2);
        this.m_edgesVisible = bl;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        NodeItem nodeItem;
        Graph graph = itemRegistry.getGraph();
        Graph graph2 = itemRegistry.getFilteredGraph();
        if (graph2 instanceof DefaultGraph) {
            ((DefaultGraph)graph2).reinit(graph.isDirected());
        } else {
            graph2 = new DefaultGraph(graph.isDirected());
        }
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            nodeItem = itemRegistry.getNodeItem((Node)iterator.next(), true, true);
            graph2.addNode(nodeItem);
        }
        iterator = graph2.getNodes();
        while (iterator.hasNext()) {
            nodeItem = (NodeItem)iterator.next();
            Node node = (Node)nodeItem.getEntity();
            Iterator iterator2 = node.getEdges();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                Node node2 = edge.getAdjacentNode(node);
                EdgeItem edgeItem = itemRegistry.getEdgeItem(edge, true);
                graph2.addEdge(edgeItem);
                if (this.m_edgesVisible) continue;
                edgeItem.setVisible(false);
            }
        }
        itemRegistry.setFilteredGraph(graph2);
        super.run(itemRegistry, d);
    }
}

