/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.Node;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class TreeAggregateFilter
extends Filter {
    private Point2D m_anchor = null;

    public TreeAggregateFilter() {
        super("aggregate", true);
    }

    public void run(ItemRegistry itemRegistry, double d) {
        this.m_anchor = this.getLayoutAnchor(itemRegistry);
        Iterator iterator = itemRegistry.getNodeItems();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            Node node = (Node)nodeItem.getEntity();
            int n = 0;
            if (nodeItem.getChildCount() != 0 || (n = node.getEdgeCount() - nodeItem.getEdgeCount()) <= 0) continue;
            AggregateItem aggregateItem = itemRegistry.getAggregateItem(node, true);
            Point2D point2D = nodeItem.getEndLocation();
            Point2D point2D2 = nodeItem.getStartLocation();
            aggregateItem.setLocation(point2D2);
            aggregateItem.updateLocation(point2D);
            aggregateItem.setLocation(point2D);
            this.setOrientation(aggregateItem);
            aggregateItem.setAggregateSize(n);
        }
        super.run(itemRegistry, d);
    }

    public Point2D getLayoutAnchor(ItemRegistry itemRegistry) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (itemRegistry != null) {
            Display display = itemRegistry.getDisplay(0);
            ((Point2D)double_).setLocation((double)display.getWidth() / 2.0, (double)display.getHeight() / 2.0);
            display.getInverseTransform().transform(double_, double_);
        }
        return double_;
    }

    protected void setOrientation(AggregateItem aggregateItem) {
        Point2D point2D = aggregateItem.getEndLocation();
        Point2D point2D2 = aggregateItem.getStartLocation();
        double d = this.m_anchor.getX();
        double d2 = this.m_anchor.getY();
        double d3 = point2D2.getX() - d;
        double d4 = point2D2.getY() - d2;
        double d5 = point2D.getX() - d;
        double d6 = point2D.getY() - d2;
        double d7 = Math.atan2(d6, d5);
        double d8 = d3 == 0.0 && d4 == 0.0 ? d7 : Math.atan2(d4, d3);
        aggregateItem.setStartOrientation(d8);
        aggregateItem.setOrientation(d7);
        aggregateItem.setEndOrientation(d7);
    }
}

