/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Iterator;

public class TreeEdgeFilter
extends Filter {
    private boolean m_edgesVisible;

    public TreeEdgeFilter() {
        this(true);
    }

    public TreeEdgeFilter(boolean bl) {
        super("edge", true);
        this.m_edgesVisible = bl;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Iterator iterator = itemRegistry.getNodeItems();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            TreeNode treeNode = (TreeNode)itemRegistry.getEntity(nodeItem);
            if (treeNode.getChildCount() <= 0) continue;
            Iterator iterator2 = treeNode.getChildEdges();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                TreeNode treeNode2 = (TreeNode)edge.getAdjacentNode(treeNode);
                if (!itemRegistry.isVisible(treeNode2)) continue;
                EdgeItem edgeItem = itemRegistry.getEdgeItem(edge, true);
                nodeItem.addChild(edgeItem);
                if (this.m_edgesVisible) continue;
                edgeItem.setVisible(false);
            }
        }
        super.run(itemRegistry, d);
    }
}

