/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.event;

import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.util.EventObject;

public class FocusEvent
extends EventObject {
    public static final Entity[] EMPTY = new Entity[0];
    public static final int FOCUS_ADDED = 0;
    public static final int FOCUS_REMOVED = 1;
    public static final int FOCUS_SET = 2;
    private Entity[] m_added;
    private Entity[] m_removed;
    private long m_when;
    private int m_type;

    public FocusEvent(FocusSet focusSet, int n, Entity[] entityArray, Entity[] entityArray2) {
        super(focusSet);
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognized event type:" + n);
        }
        this.m_when = System.currentTimeMillis();
        this.m_type = n;
        this.m_added = entityArray == null ? EMPTY : entityArray;
        this.m_removed = entityArray2 == null ? EMPTY : entityArray2;
    }

    public long getWhen() {
        return this.m_when;
    }

    public int getEventType() {
        return this.m_type;
    }

    public FocusSet getFocusSet() {
        return (FocusSet)this.getSource();
    }

    public Entity[] getAddedFoci() {
        return this.m_added;
    }

    public Entity[] getRemovedFoci() {
        return this.m_removed;
    }

    public Entity getFirstAdded() {
        return this.m_added.length > 0 ? this.m_added[0] : null;
    }

    public Entity getFirstRemoved() {
        return this.m_removed.length > 0 ? this.m_removed[0] : null;
    }
}

