/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.event;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.event.ItemRegistryListener;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class PrefuseEventLogger
implements ControlListener,
ItemRegistryListener,
FocusListener,
ComponentListener {
    public static final int LOG_INTERFACE = 1;
    public static final int LOG_FOCUS = 2;
    public static final int LOG_REGISTRY = 4;
    public static final int LOG_ALL = 7;
    public static final String ITEM_DRAGGED = "ITEM-DRAGGED";
    public static final String ITEM_MOVED = "ITEM-MOVED";
    public static final String ITEM_WHEEL_MOVED = "ITEM-WHEEL-MOVED";
    public static final String ITEM_CLICKED = "ITEM-CLICKED";
    public static final String ITEM_PRESSED = "ITEM-PRESSED";
    public static final String ITEM_RELEASED = "ITEM-RELEASED";
    public static final String ITEM_ENTERED = "ITEM-ENTERED";
    public static final String ITEM_EXITED = "ITEM-EXITED";
    public static final String ITEM_KEY_PRESSED = "ITEM-KEY-PRESSED";
    public static final String ITEM_KEY_RELEASED = "ITEM-KEY-RELEASED";
    public static final String ITEM_KEY_TYPED = "ITEM-KEY-TYPED";
    public static final String MOUSE_ENTERED = "MOUSE-ENTERED";
    public static final String MOUSE_EXITED = "MOUSE-EXITED";
    public static final String MOUSE_PRESSED = "MOUSE-PRESSED";
    public static final String MOUSE_RELEASED = "MOUSE-RELEASED";
    public static final String MOUSE_CLICKED = "MOUSE-CLICKED";
    public static final String MOUSE_DRAGGED = "MOUSE-DRAGGED";
    public static final String MOUSE_MOVED = "MOUSE-MOVED";
    public static final String MOUSE_WHEEL_MOVED = "MOUSE-WHEEL-MOVED";
    public static final String KEY_PRESSED = "KEY-PRESSED";
    public static final String KEY_RELEASED = "KEY-RELEASED";
    public static final String KEY_TYPED = "KEY-TYPED";
    public static final String FOCUS_CHANGED = "FOCUS-CHANGED";
    public static final String REGISTRY_ITEM_ADDED = "REGISTRY-ITEM-ADDED";
    public static final String REGISTRY_ITEM_REMOVED = "REGISTRY-ITEM-REMOVED";
    public static final String WINDOW_POSITION = "WINDOW-POSITION";
    private ItemRegistry m_registry;
    private Display m_display;
    private String m_label;
    private boolean m_logging;
    private int m_state;
    private PrintStream m_out;

    public PrefuseEventLogger(ItemRegistry itemRegistry, Display display, int n, String string) {
        this.m_registry = itemRegistry;
        this.m_display = display;
        this.m_state = n;
        this.m_label = string;
        this.m_logging = false;
    }

    public PrefuseEventLogger(ItemRegistry itemRegistry, int n, String string) {
        this(itemRegistry, null, n, string);
    }

    public PrefuseEventLogger(Display display, String string) {
        this(null, display, 1, string);
    }

    public synchronized void start(String string) throws FileNotFoundException {
        Container container;
        if (this.m_logging) {
            throw new IllegalStateException("Can't start an already running logger!");
        }
        this.m_out = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.m_logging = true;
        if (this.m_display != null && (this.m_state & 1) > 0) {
            this.m_display.addControlListener(this);
        }
        if (this.m_registry != null && (this.m_state & 2) > 0) {
            this.m_registry.getDefaultFocusSet().addFocusListener(this);
        }
        if (this.m_registry != null && (this.m_state & 4) > 0) {
            this.m_registry.addItemRegistryListener(this);
        }
        for (container = this.m_display.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container != null) {
            container.addComponentListener(this);
        }
        Point point = this.m_display.getLocationOnScreen();
        this.log("WINDOW-POSITION\t(" + point.x + "," + point.y + ")");
    }

    public synchronized void stop() {
        Container container;
        if (!this.m_logging) {
            return;
        }
        if (this.m_display != null && (this.m_state & 1) > 0) {
            this.m_display.removeControlListener(this);
        }
        if (this.m_registry != null && (this.m_state & 2) > 0) {
            this.m_registry.getDefaultFocusSet().removeFocusListener(this);
        }
        if (this.m_registry != null && (this.m_state & 4) > 0) {
            this.m_registry.removeItemRegistryListener(this);
        }
        for (container = this.m_display.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container != null) {
            container.removeComponentListener(this);
        }
        this.m_out.flush();
        this.m_out.close();
        this.m_logging = false;
    }

    public synchronized boolean isRunning() {
        return this.m_logging;
    }

    public void log(String string) {
        if (!this.m_logging) {
            throw new IllegalStateException("Logger isn't running!");
        }
        this.m_out.println(System.currentTimeMillis() + "\t" + string);
    }

    public void log(long l, String string) {
        if (!this.m_logging) {
            throw new IllegalStateException("Logger isn't running!");
        }
        this.m_out.println(l + "\t" + string);
    }

    public void logMouseEvent(String string, MouseEvent mouseEvent) {
        string = string + "\t[id=" + mouseEvent.getID() + ",x=" + mouseEvent.getX() + ",y=" + mouseEvent.getY() + ",button=" + mouseEvent.getButton() + ",clickCount=" + mouseEvent.getClickCount() + ",modifiers=" + mouseEvent.getModifiers() + "]";
        this.log(mouseEvent.getWhen(), string);
    }

    public void logMouseWheelEvent(String string, MouseWheelEvent mouseWheelEvent) {
        string = string + "\t[id=" + mouseWheelEvent.getID() + ",x=" + mouseWheelEvent.getX() + ",y=" + mouseWheelEvent.getY() + ",button=" + mouseWheelEvent.getButton() + ",clickCount=" + mouseWheelEvent.getClickCount() + ",modifiers=" + mouseWheelEvent.getModifiers() + ",scrollType=" + mouseWheelEvent.getScrollType() + ",scrollAmount=" + mouseWheelEvent.getScrollAmount() + ",wheelRotation=" + mouseWheelEvent.getWheelRotation() + "]";
        this.log(mouseWheelEvent.getWhen(), string);
    }

    public void logKeyEvent(String string, KeyEvent keyEvent) {
        string = string + "\t[id=" + keyEvent.getID() + ",keyCode=" + keyEvent.getKeyCode() + ",keyChar=" + keyEvent.getKeyChar() + ",modifiers=" + keyEvent.getModifiers() + ",keyText=" + KeyEvent.getKeyText(keyEvent.getKeyCode()) + "]";
        this.log(keyEvent.getWhen(), string);
    }

    public void logFocusEvent(FocusEvent focusEvent) {
        int n;
        Entity[] entityArray = null;
        StringBuffer stringBuffer = new StringBuffer(FOCUS_CHANGED);
        stringBuffer.append("\t[");
        entityArray = focusEvent.getAddedFoci();
        for (n = 0; n < entityArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getEntityString(entityArray[n]));
        }
        stringBuffer.append("]\t[");
        entityArray = focusEvent.getRemovedFoci();
        for (n = 0; n < entityArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getEntityString(entityArray[n]));
        }
        stringBuffer.append("]");
        this.log(focusEvent.getWhen(), stringBuffer.toString());
    }

    protected String getEntityString(Entity entity) {
        return entity == null ? "NULL" : entity.getAttribute(this.m_label);
    }

    protected String getItemString(VisualItem visualItem) {
        return visualItem == null ? "NULL" : this.getEntityString(visualItem.getEntity());
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Point point = this.m_display.getLocationOnScreen();
        this.log("WINDOW-POSITION\t(" + point.x + "," + point.y + ")");
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-DRAGGED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemMoved(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-MOVED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemWheelMoved(VisualItem visualItem, MouseWheelEvent mouseWheelEvent) {
        this.logMouseWheelEvent("ITEM-WHEEL-MOVED\t" + this.getItemString(visualItem), mouseWheelEvent);
    }

    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-CLICKED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-PRESSED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-RELEASED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-ENTERED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        this.logMouseEvent("ITEM-EXITED\t" + this.getItemString(visualItem), mouseEvent);
    }

    public void itemKeyPressed(VisualItem visualItem, KeyEvent keyEvent) {
        this.logKeyEvent("ITEM-KEY-PRESSED\t" + this.getItemString(visualItem), keyEvent);
    }

    public void itemKeyReleased(VisualItem visualItem, KeyEvent keyEvent) {
        this.logKeyEvent("ITEM-KEY-RELEASED\t" + this.getItemString(visualItem), keyEvent);
    }

    public void itemKeyTyped(VisualItem visualItem, KeyEvent keyEvent) {
        this.logKeyEvent("ITEM-KEY-TYPED\t" + this.getItemString(visualItem), keyEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_ENTERED, mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_EXITED, mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_PRESSED, mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_RELEASED, mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_CLICKED, mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_DRAGGED, mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.logMouseEvent(MOUSE_MOVED, mouseEvent);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.logMouseWheelEvent(ITEM_WHEEL_MOVED, mouseWheelEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.logKeyEvent(KEY_PRESSED, keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.logKeyEvent(KEY_RELEASED, keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.logKeyEvent(KEY_TYPED, keyEvent);
    }

    public void registryItemAdded(VisualItem visualItem) {
        this.log("REGISTRY-ITEM-ADDED\t" + visualItem.getItemClass() + "\t" + visualItem.getAttribute(this.m_label));
    }

    public void registryItemRemoved(VisualItem visualItem) {
        this.log("REGISTRY-ITEM-REMOVED\t" + visualItem.getItemClass() + "\t" + visualItem.getAttribute(this.m_label));
    }

    public void focusChanged(FocusEvent focusEvent) {
        this.logFocusEvent(focusEvent);
    }
}

