/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.focus;

import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusEventMulticaster;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.util.Trie;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class PrefixSearchFocusSet
implements FocusSet {
    private FocusListener m_listener = null;
    private LinkedHashSet m_set = new LinkedHashSet();
    private Trie m_trie;
    private Trie.TrieNode m_curNode;
    private String m_delim = ", ";
    private String m_query = null;

    public PrefixSearchFocusSet() {
        this(false);
    }

    public PrefixSearchFocusSet(boolean bl) {
        this.m_trie = new Trie(bl);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.m_listener = FocusEventMulticaster.add(this.m_listener, focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.m_listener = FocusEventMulticaster.remove(this.m_listener, focusListener);
    }

    public String getDelimiterString() {
        return this.m_delim;
    }

    public void setDelimiterString(String string) {
        this.m_delim = string;
    }

    public String getQuery() {
        return this.m_query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String string) {
        FocusEvent focusEvent;
        PrefixSearchFocusSet prefixSearchFocusSet = this;
        synchronized (prefixSearchFocusSet) {
            Entity[] entityArray;
            Entity[] entityArray2 = this.m_set.toArray(FocusEvent.EMPTY);
            this.m_set.clear();
            this.m_query = string;
            this.m_curNode = this.m_trie.find(string);
            if (this.m_curNode != null) {
                entityArray = this.trieIterator();
                while (entityArray.hasNext()) {
                    this.m_set.add(entityArray.next());
                }
            }
            entityArray = this.m_set.toArray(FocusEvent.EMPTY);
            focusEvent = new FocusEvent(this, 2, entityArray, entityArray2);
        }
        this.m_listener.focusChanged(focusEvent);
    }

    public static Tree getTree(Iterator iterator, String string) {
        PrefixSearchFocusSet prefixSearchFocusSet = new PrefixSearchFocusSet(false);
        prefixSearchFocusSet.index(iterator, string);
        return prefixSearchFocusSet.m_trie.tree();
    }

    public synchronized void index(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            this.index(entity, string);
        }
    }

    public synchronized void index(Entity entity, String string) {
        String string2 = entity.getAttribute(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.m_delim);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.addString(string3, entity);
        }
    }

    private void addString(String string, Entity entity) {
        this.m_trie.addString(string, entity);
    }

    public synchronized void remove(Entity entity, String string) {
        String string2 = entity.getAttribute(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.m_delim);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.removeString(string3, entity);
        }
    }

    private void removeString(String string, Entity entity) {
        this.m_trie.removeString(string, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FocusEvent focusEvent;
        PrefixSearchFocusSet prefixSearchFocusSet = this;
        synchronized (prefixSearchFocusSet) {
            this.m_curNode = null;
            this.m_query = null;
            Entity[] entityArray = this.m_set.toArray(FocusEvent.EMPTY);
            this.m_set.clear();
            focusEvent = new FocusEvent(this, 1, null, entityArray);
        }
        this.m_listener.focusChanged(focusEvent);
    }

    public synchronized Iterator iterator() {
        if (this.m_curNode == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.m_set.iterator();
    }

    private Iterator trieIterator() {
        Trie trie = this.m_trie;
        trie.getClass();
        return new Trie.TrieIterator(trie, this.m_curNode);
    }

    public synchronized int size() {
        return this.m_curNode == null ? 0 : this.m_set.size();
    }

    public synchronized boolean contains(Entity entity) {
        return this.m_set.contains(entity);
    }

    public void add(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void add(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void remove(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void remove(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void set(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void set(Collection collection) {
        throw new UnsupportedOperationException();
    }
}

