/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.collections.NodeIterator;
import edu.berkeley.guir.prefuse.graph.DefaultEntity;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultNode
extends DefaultEntity
implements Node {
    protected List m_edges = new ArrayList(3);

    public boolean addEdge(Edge edge) {
        return this.addEdge(this.m_edges.size(), edge);
    }

    public boolean addEdge(int n, Edge edge) {
        if (edge.isDirected() && this != edge.getFirstNode()) {
            throw new IllegalArgumentException("Directed edges must have the source as the first node in the Edge.");
        }
        Node node = edge.getAdjacentNode(this);
        if (node == null) {
            throw new IllegalArgumentException("The Edge must be incident on this Node.");
        }
        if (this.isNeighbor(node)) {
            return false;
        }
        this.m_edges.add(n, edge);
        return true;
    }

    public Edge getEdge(int n) {
        return (Edge)this.m_edges.get(n);
    }

    public Edge getEdge(Node node) {
        for (int i = 0; i < this.m_edges.size(); ++i) {
            Edge edge = (Edge)this.m_edges.get(i);
            if (node != edge.getAdjacentNode(this)) continue;
            return edge;
        }
        throw new NoSuchElementException();
    }

    public int getEdgeCount() {
        return this.m_edges.size();
    }

    public Iterator getEdges() {
        return this.m_edges.iterator();
    }

    public int getIndex(Edge edge) {
        return this.m_edges.indexOf(edge);
    }

    public int getIndex(Node node) {
        for (int i = 0; i < this.m_edges.size(); ++i) {
            if (node != ((Edge)this.m_edges.get(i)).getAdjacentNode(this)) continue;
            return i;
        }
        return -1;
    }

    public Node getNeighbor(int n) {
        return ((Edge)this.m_edges.get(n)).getAdjacentNode(this);
    }

    public Iterator getNeighbors() {
        return new NodeIterator(this.m_edges.iterator(), this);
    }

    public boolean isIncidentEdge(Edge edge) {
        return this.m_edges.indexOf(edge) > -1;
    }

    public boolean isNeighbor(Node node) {
        return this.getIndex(node) > -1;
    }

    public void removeAllNeighbors() {
        this.m_edges.clear();
    }

    public boolean removeEdge(Edge edge) {
        int n = this.m_edges.indexOf(edge);
        return n > -1 ? this.m_edges.remove(n) != null : false;
    }

    public Edge removeEdge(int n) {
        return (Edge)this.m_edges.remove(n);
    }

    public boolean removeNeighbor(Node node) {
        for (int i = 0; i < this.m_edges.size(); ++i) {
            if (node != ((Edge)this.m_edges.get(i)).getAdjacentNode(this)) continue;
            return this.m_edges.remove(i) != null;
        }
        return false;
    }

    public Node removeNeighbor(int n) {
        return ((Edge)this.m_edges.remove(n)).getAdjacentNode(this);
    }
}

