/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.external;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.event.GraphLoaderListener;
import edu.berkeley.guir.prefuse.graph.event.GraphLoaderMulticaster;
import edu.berkeley.guir.prefuse.graph.external.ExternalEntity;
import edu.berkeley.guir.prefuse.graph.external.ExternalNode;
import edu.berkeley.guir.prefuse.graph.external.ExternalTreeNode;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class GraphLoader
implements Runnable {
    public static final int LOAD_NEIGHBORS = 0;
    public static final int LOAD_CHILDREN = 1;
    public static final int LOAD_PARENT = 2;
    protected List m_queue = new LinkedList();
    protected Graph m_graph;
    protected ItemRegistry m_registry;
    protected int m_maxSize = 5000;
    protected String m_keyField;
    protected LinkedHashMap m_cache = new LinkedHashMap(this.m_maxSize, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return GraphLoader.this.evict((ExternalEntity)entry.getValue());
        }
    };
    protected GraphLoaderListener m_listener;

    public GraphLoader(ItemRegistry itemRegistry, String string) {
        this.m_keyField = string;
        this.m_registry = itemRegistry;
        this.m_graph = itemRegistry.getGraph();
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    public void setMaximumCacheSize(int n) {
        this.m_maxSize = n;
    }

    public int getMaximumCacheSize() {
        return this.m_maxSize;
    }

    public void addGraphLoaderListener(GraphLoaderListener graphLoaderListener) {
        this.m_listener = GraphLoaderMulticaster.add(this.m_listener, graphLoaderListener);
    }

    public void removeGraphLoaderListener(GraphLoaderListener graphLoaderListener) {
        this.m_listener = GraphLoaderMulticaster.remove(this.m_listener, graphLoaderListener);
    }

    public void touch(ExternalEntity externalEntity) {
        this.m_cache.get(externalEntity.getAttribute(this.m_keyField));
    }

    public synchronized void loadNeighbors(ExternalNode externalNode) {
        this.submit(new Job(0, externalNode));
    }

    public synchronized void loadChildren(ExternalTreeNode externalTreeNode) {
        this.submit(new Job(1, externalTreeNode));
    }

    public synchronized void loadParent(ExternalTreeNode externalTreeNode) {
        this.submit(new Job(2, externalTreeNode));
    }

    private synchronized void submit(Job job) {
        if (!this.m_queue.contains(job)) {
            this.m_queue.add(job);
            this.notifyAll();
        }
    }

    public boolean evict(ExternalEntity externalEntity) {
        boolean bl;
        boolean bl2 = bl = this.m_cache.size() > this.m_maxSize && !this.m_registry.isVisible(externalEntity);
        if (bl && this.m_listener != null) {
            this.m_listener.entityUnloaded(this, externalEntity);
        }
        if (bl) {
            externalEntity.unload();
            this.m_graph.removeNode(externalEntity);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object;
            Job job;
            if ((job = this.getNextJob()) != null) {
                if (job.type == 0) {
                    object = (ExternalNode)job.n;
                    this.getNeighbors((ExternalNode)object);
                    ((ExternalNode)object).setNeighborsLoaded(true);
                    continue;
                }
                if (job.type == 1) {
                    object = (ExternalTreeNode)job.n;
                    this.getChildren((ExternalTreeNode)object);
                    ((ExternalTreeNode)object).setChildrenLoaded(true);
                    continue;
                }
                if (job.type != 2) continue;
                object = (ExternalTreeNode)job.n;
                this.getParent((ExternalTreeNode)object);
                ((ExternalTreeNode)object).setParentLoaded(true);
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected synchronized Job getNextJob() {
        return this.m_queue.isEmpty() ? null : (Job)this.m_queue.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foundNode(int n, ExternalEntity externalEntity, ExternalEntity externalEntity2, Edge edge) {
        boolean bl = false;
        String string = externalEntity2.getAttribute(this.m_keyField);
        if (this.m_cache.containsKey(string)) {
            externalEntity2 = (ExternalEntity)this.m_cache.get(string);
            bl = true;
        } else {
            this.m_cache.put(string, externalEntity2);
        }
        externalEntity2.setLoader(this);
        if (edge == null && externalEntity != null) {
            edge = n == 2 ? new DefaultEdge(externalEntity2, externalEntity, this.m_graph.isDirected()) : new DefaultEdge(externalEntity, externalEntity2, this.m_graph.isDirected());
        }
        ItemRegistry itemRegistry = this.m_registry;
        synchronized (itemRegistry) {
            if (n == 0) {
                this.m_graph.addNode(externalEntity2);
                if (externalEntity != null) {
                    this.m_graph.addEdge(edge);
                }
            } else if (externalEntity != null && (n == 2 || n == 1)) {
                ((Tree)this.m_graph).addChild(edge);
                if (n == 1) {
                    ((ExternalTreeNode)externalEntity2).setParentLoaded(true);
                }
            }
        }
        if (this.m_listener != null && !bl) {
            this.m_listener.entityLoaded(this, externalEntity2);
        }
    }

    protected abstract void getNeighbors(ExternalNode var1);

    protected abstract void getChildren(ExternalTreeNode var1);

    protected abstract void getParent(ExternalTreeNode var1);

    public class Job {
        int type;
        ExternalEntity n;

        public Job(int n, ExternalEntity externalEntity) {
            this.type = n;
            this.n = externalEntity;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Job)) {
                return false;
            }
            Job job = (Job)object;
            return this.type == job.type && this.n == job.n;
        }

        public int hashCode() {
            return this.type ^ this.n.hashCode();
        }
    }
}

