/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import edu.berkeley.guir.prefuse.util.GeometryLib;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DefaultEdgeRenderer
extends ShapeRenderer {
    public static final String EDGE_TYPE = "edgeType";
    protected static final double HALF_PI = 1.5707963267948966;
    protected static final Polygon DEFAULT_ARROW_HEAD = new Polygon(new int[]{0, -4, 4, 0}, new int[]{0, -12, -12, 0}, 4);
    public static final int EDGE_TYPE_LINE = 0;
    public static final int EDGE_TYPE_CURVE = 1;
    public static final int WEIGHT_TYPE_NONE = 0;
    public static final int WEIGHT_TYPE_LINEAR = 1;
    public static final int WEIGHT_TYPE_LOG = 2;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 1;
    public static final int ALIGNMENT_TOP = 0;
    protected Line2D m_line = new Line2D.Float();
    protected CubicCurve2D m_cubic = new CubicCurve2D.Float();
    protected int m_edgeType = 0;
    protected int m_weightType = 1;
    protected int m_xAlign1 = 2;
    protected int m_yAlign1 = 2;
    protected int m_xAlign2 = 2;
    protected int m_yAlign2 = 2;
    protected int m_width = 1;
    protected int m_curWidth = 1;
    protected Point2D[] m_tmpPoints = new Point2D[2];
    protected Point2D[] m_ctrlPoints = new Point2D[2];
    protected Point2D[] m_isctPoints = new Point2D[2];
    protected String m_weightLabel = "weight";
    protected boolean m_directed = false;
    protected Polygon m_arrowHead = DEFAULT_ARROW_HEAD;
    protected AffineTransform m_arrowTrans = new AffineTransform();

    public DefaultEdgeRenderer() {
        this.m_tmpPoints[0] = new Point2D.Float();
        this.m_tmpPoints[1] = new Point2D.Float();
        this.m_ctrlPoints[0] = new Point2D.Float();
        this.m_ctrlPoints[1] = new Point2D.Float();
        this.m_isctPoints[0] = new Point2D.Float();
        this.m_isctPoints[1] = new Point2D.Float();
    }

    public String getWeightAttributeName() {
        return this.m_weightLabel;
    }

    public void setWeightAttributeName(String string) {
        this.m_weightLabel = string;
    }

    public int getWeightType() {
        return this.m_weightType;
    }

    public void setWeightType(int n) {
        this.m_weightType = n;
    }

    public int getRenderType() {
        if (this.m_directed) {
            return 3;
        }
        return 1;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        EdgeItem edgeItem = (EdgeItem)visualItem;
        VisualItem visualItem2 = (VisualItem)((Object)edgeItem.getFirstNode());
        VisualItem visualItem3 = (VisualItem)((Object)edgeItem.getSecondNode());
        String string = (String)edgeItem.getVizAttribute(EDGE_TYPE);
        int n = this.m_edgeType;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DefaultEdgeRenderer.getAlignedPoint(this.m_tmpPoints[0], visualItem2.getRenderer().getBoundsRef(visualItem2), this.m_xAlign1, this.m_yAlign1);
        DefaultEdgeRenderer.getAlignedPoint(this.m_tmpPoints[1], visualItem3.getRenderer().getBoundsRef(visualItem3), this.m_xAlign2, this.m_yAlign2);
        double d = this.m_tmpPoints[0].getX();
        double d2 = this.m_tmpPoints[0].getY();
        double d3 = this.m_tmpPoints[1].getX();
        double d4 = this.m_tmpPoints[1].getY();
        this.m_curWidth = this.getLineWidth(visualItem);
        switch (n) {
            case 0: {
                this.m_line.setLine(d, d2, d3, d4);
                return this.m_line;
            }
            case 1: {
                this.getCurveControlPoints(edgeItem, this.m_ctrlPoints, d, d2, d3, d4);
                this.m_cubic.setCurve(d, d2, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), d3, d4);
                return this.m_cubic;
            }
        }
        throw new IllegalStateException("Unknown edge type");
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        super.render(graphics2D, visualItem);
        EdgeItem edgeItem = (EdgeItem)visualItem;
        if (edgeItem.isDirected()) {
            int n;
            Point2D point2D = null;
            Point2D point2D2 = null;
            String string = (String)visualItem.getVizAttribute(EDGE_TYPE);
            int n2 = this.m_edgeType;
            if (string != null) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (n2) {
                case 0: {
                    point2D = this.m_tmpPoints[0];
                    point2D2 = this.m_tmpPoints[1];
                    n = this.m_width;
                    break;
                }
                case 1: {
                    point2D = this.m_ctrlPoints[1];
                    point2D2 = this.m_tmpPoints[1];
                    n = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown edge type.");
                }
            }
            VisualItem visualItem2 = (VisualItem)((Object)edgeItem.getSecondNode());
            Rectangle2D rectangle2D = visualItem2.getBounds();
            int n3 = GeometryLib.intersectLineRectangle(point2D, point2D2, rectangle2D, this.m_isctPoints);
            if (n3 > 0) {
                point2D2 = this.m_isctPoints[0];
            }
            AffineTransform affineTransform = this.getArrowTrans(point2D, point2D2, n);
            Shape shape = affineTransform.createTransformedShape(this.m_arrowHead);
            graphics2D.setPaint(visualItem.getFillColor());
            graphics2D.fill(shape);
        }
    }

    protected AffineTransform getArrowTrans(Point2D point2D, Point2D point2D2, int n) {
        this.m_arrowTrans.setToTranslation(point2D2.getX(), point2D2.getY());
        this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX()));
        if (n > 1) {
            double d = 2.0 * (double)(n - 1) / 4.0 + 1.0;
            this.m_arrowTrans.scale(d, d);
        }
        return this.m_arrowTrans;
    }

    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return false;
        }
        double d = Math.max(2, this.getLineWidth(visualItem));
        double d2 = d / 2.0;
        return shape.intersects(point2D.getX() - d2, point2D.getY() - d2, d, d);
    }

    protected int getLineWidth(VisualItem visualItem) {
        if (this.m_weightType == 0) {
            return this.m_width;
        }
        String string = visualItem.getAttribute(this.m_weightLabel);
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                if (this.m_weightType == 1) {
                    return (int)Math.round(d);
                }
                if (this.m_weightType == 2) {
                    return Math.max(1, 1 + (int)Math.round(Math.log(d)));
                }
            }
            catch (Exception exception) {
                System.err.println("Weight value is not a valid number!");
                exception.printStackTrace();
            }
        }
        return this.m_width;
    }

    protected BasicStroke getStroke(VisualItem visualItem) {
        return this.m_curWidth == 1 ? null : new BasicStroke(this.m_curWidth);
    }

    protected void getCurveControlPoints(EdgeItem edgeItem, Point2D[] point2DArray, double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        point2DArray[0].setLocation(d + 2.0 * d5 / 3.0, d2);
        point2DArray[1].setLocation(d3 - d5 / 8.0, d4 - d6 / 8.0);
    }

    protected static void getAlignedPoint(Point2D point2D, Rectangle2D rectangle2D, int n, int n2) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (n == 2) {
            d += d3 / 2.0;
        } else if (n == 1) {
            d += d3;
        }
        if (n2 == 2) {
            d2 += d4 / 2.0;
        } else if (n2 == 1) {
            d2 += d4;
        }
        point2D.setLocation(d, d2);
    }

    public int getEdgeType() {
        return this.m_edgeType;
    }

    public void setEdgeType(int n) {
        this.m_edgeType = n;
    }

    public int getHorizontalAlignment1() {
        return this.m_xAlign1;
    }

    public int getVerticalAlignment1() {
        return this.m_yAlign1;
    }

    public int getHorizontalAlignment2() {
        return this.m_xAlign2;
    }

    public int getVerticalAlignment2() {
        return this.m_yAlign2;
    }

    public void setHorizontalAlignment1(int n) {
        this.m_xAlign1 = n;
    }

    public void setVerticalAlignment1(int n) {
        this.m_yAlign1 = n;
    }

    public void setHorizontalAlignment2(int n) {
        this.m_xAlign2 = n;
    }

    public void setVerticalAlignment2(int n) {
        this.m_yAlign2 = n;
    }

    public void setWidth(int n) {
        this.m_width = n;
    }
}

