/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import edu.berkeley.guir.prefuse.util.FontLib;
import edu.berkeley.guir.prefuse.util.StringAbbreviator;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class TextItemRenderer
extends ShapeRenderer {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 1;
    public static final int ALIGNMENT_TOP = 0;
    protected String m_labelName = "label";
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_horizBorder = 3;
    protected int m_vertBorder = 0;
    protected int m_maxTextWidth = -1;
    protected int m_abbrevType = 3;
    protected StringAbbreviator m_abbrev = StringAbbreviator.getInstance();
    protected RectangularShape m_textBox = new Rectangle2D.Float();
    protected Font m_font = FontLib.getFont("SansSerif", 0, 10);
    protected Point2D m_tmpPoint = new Point2D.Float();

    public void setFont(Font font) {
        this.m_font = font;
    }

    public void setRoundedCorner(int n, int n2) {
        if (!(n != 0 && n2 != 0 || this.m_textBox instanceof Rectangle2D)) {
            this.m_textBox = new Rectangle2D.Float();
        } else {
            if (!(this.m_textBox instanceof RoundRectangle2D)) {
                this.m_textBox = new RoundRectangle2D.Float();
            }
            ((RoundRectangle2D)this.m_textBox).setRoundRect(0.0, 0.0, 10.0, 10.0, n, n2);
        }
    }

    public String getTextAttributeName() {
        return this.m_labelName;
    }

    public void setTextAttributeName(String string) {
        this.m_labelName = string;
    }

    public void setMaxTextWidth(int n) {
        this.m_maxTextWidth = n;
    }

    public void setAbbrevType(int n) {
        this.m_abbrevType = n;
    }

    protected String getText(VisualItem visualItem) {
        String string = visualItem.getAttribute(this.m_labelName);
        if (this.m_maxTextWidth > -1) {
            FontMetrics fontMetrics;
            Font font = visualItem.getFont();
            if (font == null) {
                font = this.m_font;
            }
            if ((fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(font)).stringWidth(string) > this.m_maxTextWidth) {
                string = this.m_abbrev.abbreviate(string, this.m_abbrevType, fontMetrics, this.m_maxTextWidth);
            }
        }
        return string;
    }

    protected boolean isHyperlink(VisualItem visualItem) {
        Boolean bl = (Boolean)visualItem.getVizAttribute(this.m_labelName + "_LINK");
        return bl != null && Boolean.TRUE.equals(bl);
    }

    protected Shape getRawShape(VisualItem visualItem) {
        String string = this.getText(visualItem);
        if (string == null) {
            string = "";
        }
        this.m_font = visualItem.getFont();
        double d = visualItem.getSize();
        if (d != 1.0) {
            this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), d * (double)this.m_font.getSize());
        }
        FontMetrics fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
        double d2 = (double)fontMetrics.getHeight() + d * 2.0 * (double)this.m_vertBorder;
        double d3 = (double)fontMetrics.stringWidth(string) + d * 2.0 * (double)this.m_horizBorder;
        TextItemRenderer.getAlignedPoint(this.m_tmpPoint, visualItem, d3, d2, this.m_xAlign, this.m_yAlign);
        this.m_textBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY(), d3, d2);
        return this.m_textBox;
    }

    protected static void getAlignedPoint(Point2D point2D, VisualItem visualItem, double d, double d2, int n, int n2) {
        double d3 = visualItem.getX();
        double d4 = visualItem.getY();
        if (n == 2) {
            d3 -= d / 2.0;
        } else if (n == 1) {
            d3 -= d;
        }
        if (n2 == 2) {
            d4 -= d2 / 2.0;
        } else if (n2 == 1) {
            d4 -= d2;
        }
        point2D.setLocation(d3, d4);
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            super.drawShape(graphics2D, visualItem, shape);
            String string = this.getText(visualItem);
            if (string != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                graphics2D.setPaint(visualItem.getColor());
                graphics2D.setFont(this.m_font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                double d = visualItem.getSize();
                double d2 = rectangle2D.getX() + d * (double)this.m_horizBorder;
                double d3 = rectangle2D.getY() + d * (double)this.m_vertBorder;
                graphics2D.drawString(string, (float)d2, (float)d3 + (float)fontMetrics.getAscent());
                if (this.isHyperlink(visualItem)) {
                    int n = (int)Math.round(d2);
                    int n2 = (int)Math.round(d3);
                    graphics2D.drawLine(n, n2, n + fontMetrics.stringWidth(string), n2 + fontMetrics.getHeight() - 1);
                }
            }
        }
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int n) {
        this.m_xAlign = n;
    }

    public void setVerticalAlignment(int n) {
        this.m_yAlign = n;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int n) {
        this.m_horizBorder = n;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int n) {
        this.m_vertBorder = n;
    }
}

