/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import java.awt.Font;
import java.util.HashMap;

public class FontLib {
    private static final HashMap fontMap = new HashMap();
    private static int misses = 0;
    private static int lookups = 0;

    public static Font getFont(String string, int n, double d) {
        int n2 = (int)Math.floor(d);
        return FontLib.getFont(string, n, n2);
    }

    public static Font getFont(String string, int n, int n2) {
        Integer n3 = new Integer((string.hashCode() << 8) + (n2 << 2) + n);
        Font font = null;
        font = (Font)fontMap.get(n3);
        if (font == null) {
            font = new Font(string, n, n2);
            fontMap.put(n3, font);
            ++misses;
        }
        ++lookups;
        return font;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        fontMap.clear();
    }

    public static Font getIntermediateFont(Font font, Font font2, double d) {
        int n;
        String string;
        if (d < 0.5) {
            string = font.getName();
            n = font.getStyle();
        } else {
            string = font2.getName();
            n = font2.getStyle();
        }
        int n2 = (int)Math.round(d * (double)font2.getSize() + (1.0 - d) * (double)font.getSize());
        return FontLib.getFont(string, n, n2);
    }
}

