/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;

public class StringAbbreviator {
    private static final String SUFFIX = "suffix";
    private static final String PREFIX = "prefix";
    public static final int NAME = 0;
    public static final int PHONE = 1;
    public static final int EMAIL = 2;
    public static final int TRUNCATE = 3;
    public static final int FILE = 4;
    public static final String STR_NAME = "name";
    public static final String STR_PHONE = "phone";
    public static final String STR_EMAIL = "email";
    public static final String STR_TRUNCATE = "truncate";
    public static final String STR_FILE = "file";
    protected URL datadir;
    protected String datafile;
    protected Hashtable abbrevT;
    protected static Hashtable prefixSuffixT = new Hashtable();
    private static StringAbbreviator s_abbrev;

    public StringAbbreviator(URL uRL, String string) {
        this.datadir = uRL;
        this.datafile = string;
    }

    public static StringAbbreviator getInstance() {
        return s_abbrev;
    }

    public String abbreviate(String string, int n, FontMetrics fontMetrics, int n2) {
        switch (n) {
            case 0: {
                if (fontMetrics.stringWidth(string) > n2) {
                    string = this.abbreviateName(string, false);
                }
                if (fontMetrics.stringWidth(string) <= n2) break;
                string = this.abbreviateName(string, true);
                break;
            }
            case 1: {
                if (fontMetrics.stringWidth(string) > n2) {
                    string = this.abbreviatePhone(string, 8);
                }
                if (fontMetrics.stringWidth(string) <= n2) break;
                string = this.abbreviatePhone(string, 4);
                break;
            }
            case 2: {
                if (fontMetrics.stringWidth(string) <= n2) break;
                string = this.abbreviateEmail(string);
                break;
            }
            case 4: {
                if (fontMetrics.stringWidth(string) > n2) {
                    string = this.abbreviate(string, false);
                }
                if (fontMetrics.stringWidth(string) <= n2) break;
                string = this.abbreviate(string, true);
                break;
            }
            default: {
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < n2 && n4 < string.length(); i += fontMetrics.charWidth(string.charAt(n4)), ++n4) {
                    if (!Character.isWhitespace(string.charAt(n4))) continue;
                    n3 = n4;
                }
                if (n4 < string.length() && n3 > 0) {
                    n4 = n3;
                }
                string = n4 > 0 ? string.substring(0, n4) : string;
            }
        }
        return string;
    }

    public String abbreviateName(String string, FontMetrics fontMetrics, int n) {
        return this.abbreviate(string, 0, fontMetrics, n);
    }

    public String abbreviateEmail(String string, FontMetrics fontMetrics, int n) {
        return this.abbreviate(string, 2, fontMetrics, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String abbreviate(String string, boolean bl) {
        if (this.abbrevT == null) {
            this.readAbbrFile();
        }
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(58);
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        try {
            block12: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        return stringBuffer.toString();
                    }
                    case 10: {
                        System.err.println("warning: unexpected EOL token");
                        continue block12;
                    }
                    case -2: {
                        if (bl2) {
                            bl2 = false;
                        } else if (!bl) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(new Integer((int)streamTokenizer.nval));
                        continue block12;
                    }
                    case -3: {
                        if (bl2) {
                            bl2 = false;
                        } else if (!bl) {
                            stringBuffer.append(" ");
                        }
                        if (bl) {
                            String string4 = streamTokenizer.sval.substring(0, 1);
                            if (string2.indexOf(string4) < 0) continue block12;
                            stringBuffer.append(string4);
                            continue block12;
                        }
                        string3 = (String)this.abbrevT.get(streamTokenizer.sval.toLowerCase());
                        if (string3 != null) {
                            stringBuffer.append(string3);
                            continue block12;
                        }
                        stringBuffer.append(streamTokenizer.sval);
                        continue block12;
                    }
                    case 44: {
                        stringBuffer.append((char)n);
                        continue block12;
                    }
                    case 58: {
                        stringBuffer.append((char)n);
                        continue block12;
                    }
                    case 46: {
                        if (bl) continue block12;
                        stringBuffer.append((char)n);
                        continue block12;
                    }
                    case 45: {
                        if (bl) continue block12;
                        stringBuffer.append((char)n);
                        continue block12;
                    }
                }
                if (bl) continue;
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    protected String abbreviatePhone(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(string.length() - n);
        }
        return string;
    }

    protected String abbreviateEmail(String string) {
        if (string != null && string.indexOf(64) > 0) {
            return string.substring(0, string.indexOf(64));
        }
        return string;
    }

    protected String abbreviateName(String string, boolean bl) {
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(45);
        Object var6_5 = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            block9: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        break block9;
                    }
                    case 10: {
                        System.err.println("warning: unexpected EOL token");
                        continue block9;
                    }
                    case -2: {
                        continue block9;
                    }
                    case 44: {
                        break block9;
                    }
                    case -3: {
                        if (streamTokenizer.sval.endsWith(":")) {
                            stringBuffer.append(streamTokenizer.sval + " ");
                            continue block9;
                        }
                        if (prefixSuffixT.get(streamTokenizer.sval.toLowerCase()) != null) continue block9;
                        if (!bl) {
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            string3 = streamTokenizer.sval.substring(0, 1) + ". ";
                        }
                        string2 = streamTokenizer.sval;
                        continue block9;
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
            stringBuffer.append(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void readAbbrFile() {
        this.abbrevT = new Hashtable();
        try {
            URL uRL = new URL(this.datadir, this.datafile);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringAbbreviator.parseAbbrFile(bufferedReader, this.abbrevT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseAbbrFile(BufferedReader bufferedReader, Hashtable hashtable) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.whitespaceChars(61, 61);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.commentChar(35);
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block8: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        break block8;
                    }
                    case 10: {
                        System.err.println("warning: unexpected EOL token");
                        continue block8;
                    }
                    case -2: {
                        if (bl2) {
                            hashtable.put(string, new Double(streamTokenizer.nval));
                            bl2 = false;
                            continue block8;
                        }
                        bl = true;
                        break block8;
                    }
                    case -3: {
                        if (bl2) {
                            hashtable.put(string, streamTokenizer.sval);
                            bl2 = false;
                            continue block8;
                        }
                        bl2 = true;
                        string = streamTokenizer.sval.toLowerCase();
                        continue block8;
                    }
                    default: {
                        bl = true;
                        break block8;
                    }
                }
                break;
            }
            if (bl) {
                System.out.println("Error encountered around '" + string + "'");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setAbbrFile(String string) {
        this.datafile = string;
        this.readAbbrFile();
    }

    static {
        prefixSuffixT.put("mr", PREFIX);
        prefixSuffixT.put("mr.", PREFIX);
        prefixSuffixT.put("dr", PREFIX);
        prefixSuffixT.put("dr.", PREFIX);
        prefixSuffixT.put("lt", PREFIX);
        prefixSuffixT.put("lt.", PREFIX);
        prefixSuffixT.put("gen", PREFIX);
        prefixSuffixT.put("gen.", PREFIX);
        prefixSuffixT.put("sgt", PREFIX);
        prefixSuffixT.put("sgt.", PREFIX);
        prefixSuffixT.put("cmdr", PREFIX);
        prefixSuffixT.put("cmdr.", PREFIX);
        prefixSuffixT.put("cpt", PREFIX);
        prefixSuffixT.put("cpt.", PREFIX);
        prefixSuffixT.put("ii", SUFFIX);
        prefixSuffixT.put("iii", SUFFIX);
        prefixSuffixT.put("iv", SUFFIX);
        prefixSuffixT.put("jr", SUFFIX);
        prefixSuffixT.put("jr.", SUFFIX);
        prefixSuffixT.put("sr", SUFFIX);
        prefixSuffixT.put("sr.", SUFFIX);
        s_abbrev = new StringAbbreviator(null, null);
    }
}

