/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultEntity;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class Trie {
    private TrieBranch root = new TrieBranch();
    private boolean caseSensitive = false;

    public Trie(boolean bl) {
        this.caseSensitive = bl;
    }

    public void addString(String string, Entity entity) {
        TrieLeaf trieLeaf = new TrieLeaf(string, entity);
        this.addLeaf(this.root, trieLeaf, 0);
    }

    public void removeString(String string, Entity entity) {
        this.removeLeaf(this.root, string, entity, 0);
    }

    private final int getIndex(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    private final char getChar(String string, int n) {
        char c = n < 0 || n >= string.length() ? (char)'\u0000' : string.charAt(n);
        return this.caseSensitive ? c : Character.toLowerCase(c);
    }

    private boolean removeLeaf(TrieBranch trieBranch, String string, Entity entity, int n) {
        char c = this.getChar(string, n);
        int n2 = this.getIndex(trieBranch.chars, c);
        if (n2 == -1) {
            return false;
        }
        TrieNode trieNode = trieBranch.children[n2];
        if (trieNode instanceof TrieBranch) {
            TrieBranch trieBranch2 = (TrieBranch)trieNode;
            boolean bl = this.removeLeaf(trieBranch2, string, entity, n + 1);
            if (bl) {
                --trieBranch.leafCount;
                if (trieBranch2.leafCount == 1) {
                    trieBranch.children[n2] = trieBranch2.children[trieBranch2.children[0] != null ? 0 : 1];
                }
            }
            return bl;
        }
        TrieLeaf trieLeaf = (TrieLeaf)trieNode;
        if (trieLeaf.entity == entity) {
            trieBranch.children[n2] = trieLeaf.next;
            if (trieLeaf.next == null) {
                this.repairBranch(trieBranch, n2);
            }
            --trieBranch.leafCount;
            return true;
        }
        TrieLeaf trieLeaf2 = trieLeaf.next;
        while (trieLeaf2 != null && trieLeaf2.entity != entity) {
            trieLeaf = trieLeaf2;
            trieLeaf2 = trieLeaf2.next;
        }
        if (trieLeaf2 == null) {
            return false;
        }
        TrieLeaf trieLeaf3 = (TrieLeaf)trieNode;
        while (trieLeaf3.entity != entity) {
            --trieLeaf3.leafCount;
            trieLeaf3 = trieLeaf3.next;
        }
        trieLeaf.next = trieLeaf2.next;
        --trieBranch.leafCount;
        return true;
    }

    private void repairBranch(TrieBranch trieBranch, int n) {
        if (n == 0) {
            trieBranch.children[0] = null;
        } else {
            int n2 = trieBranch.chars.length;
            char[] cArray = new char[n2 - 1];
            TrieNode[] trieNodeArray = new TrieNode[n2 - 1];
            System.arraycopy(trieBranch.chars, 0, cArray, 0, n);
            System.arraycopy(trieBranch.children, 0, trieNodeArray, 0, n);
            System.arraycopy(trieBranch.chars, n + 1, cArray, n, n2 - n - 1);
            System.arraycopy(trieBranch.children, n + 1, trieNodeArray, n, n2 - n - 1);
            trieBranch.chars = cArray;
            trieBranch.children = trieNodeArray;
        }
    }

    private void addLeaf(TrieBranch trieBranch, TrieLeaf trieLeaf, int n) {
        trieBranch.leafCount += trieLeaf.leafCount;
        char c = this.getChar(trieLeaf.word, n);
        int n2 = this.getIndex(trieBranch.chars, c);
        if (n2 == -1) {
            this.addChild(trieBranch, trieLeaf, c);
        } else {
            TrieNode trieNode = trieBranch.children[n2];
            if (trieNode == null) {
                trieBranch.children[n2] = trieLeaf;
            } else if (trieNode instanceof TrieBranch) {
                this.addLeaf((TrieBranch)trieNode, trieLeaf, n + 1);
            } else {
                TrieLeaf trieLeaf2 = (TrieLeaf)trieNode;
                if (n2 == 0 || (this.caseSensitive ? trieLeaf2.word.equals(trieLeaf.word) : trieLeaf2.word.equalsIgnoreCase(trieLeaf.word))) {
                    while (trieLeaf2.next != null) {
                        ++trieLeaf2.leafCount;
                        trieLeaf2 = trieLeaf2.next;
                    }
                    ++trieLeaf2.leafCount;
                    trieLeaf2.next = trieLeaf;
                } else {
                    TrieBranch trieBranch2 = new TrieBranch();
                    trieBranch.children[n2] = trieBranch2;
                    this.addLeaf(trieBranch2, trieLeaf2, n + 1);
                    this.addLeaf(trieBranch2, trieLeaf, n + 1);
                }
            }
        }
    }

    private void addChild(TrieBranch trieBranch, TrieNode trieNode, char c) {
        int n = trieBranch.chars.length;
        char[] cArray = new char[n + 1];
        TrieNode[] trieNodeArray = new TrieNode[n + 1];
        System.arraycopy(trieBranch.chars, 0, cArray, 0, n);
        System.arraycopy(trieBranch.children, 0, trieNodeArray, 0, n);
        cArray[n] = c;
        trieNodeArray[n] = trieNode;
        trieBranch.chars = cArray;
        trieBranch.children = trieNodeArray;
    }

    public TrieNode find(String string) {
        return string.length() < 1 ? null : this.find(string, this.root, 0);
    }

    private TrieNode find(String string, TrieBranch trieBranch, int n) {
        char c = this.getChar(string, n);
        int n2 = this.getIndex(trieBranch.chars, c);
        if (n2 == -1) {
            return null;
        }
        if (trieBranch.children[n2] instanceof TrieLeaf) {
            return trieBranch.children[n2];
        }
        if (string.length() - 1 == n) {
            return trieBranch.children[n2];
        }
        return this.find(string, (TrieBranch)trieBranch.children[n2], n + 1);
    }

    public Tree tree() {
        DefaultTreeNode defaultTreeNode = new DefaultTreeNode();
        defaultTreeNode.setAttribute("label", "root");
        this.tree(this.root, defaultTreeNode);
        return new DefaultTree(defaultTreeNode);
    }

    private void tree(TrieBranch trieBranch, TreeNode treeNode) {
        for (int i = 0; i < trieBranch.chars.length; ++i) {
            DefaultEntity defaultEntity;
            Object object;
            if (trieBranch.children[i] instanceof TrieLeaf) {
                object = (TrieLeaf)trieBranch.children[i];
                while (object != null) {
                    defaultEntity = new DefaultTreeNode();
                    defaultEntity.setAttribute("label", ((TrieLeaf)object).word);
                    DefaultEdge defaultEdge = new DefaultEdge(treeNode, (Node)((Object)defaultEntity));
                    treeNode.addChild(defaultEdge);
                    object = ((TrieLeaf)object).next;
                }
                continue;
            }
            object = new DefaultTreeNode();
            ((DefaultEntity)object).setAttribute("label", String.valueOf(trieBranch.chars[i]));
            defaultEntity = new DefaultEdge(treeNode, (Node)object);
            treeNode.addChild((Edge)((Object)defaultEntity));
            this.tree((TrieBranch)trieBranch.children[i], (TreeNode)object);
        }
    }

    public class TrieIterator
    implements Iterator {
        private LinkedList queue = new LinkedList();
        private Entity next;

        public TrieIterator(TrieNode trieNode) {
            this.queue.add(trieNode);
        }

        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public Object next() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException();
            }
            TrieNode trieNode = (TrieNode)this.queue.removeFirst();
            if (trieNode instanceof TrieLeaf) {
                TrieLeaf trieLeaf = (TrieLeaf)trieNode;
                Entity entity = trieLeaf.entity;
                if (trieLeaf.next != null) {
                    this.queue.addFirst(trieLeaf.next);
                }
                return entity;
            }
            TrieBranch trieBranch = (TrieBranch)trieNode;
            for (int i = trieBranch.chars.length - 1; i > 0; --i) {
                this.queue.addFirst(trieBranch.children[i]);
            }
            if (trieBranch.children[0] != null) {
                this.queue.addFirst(trieBranch.children[0]);
            }
            return this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class TrieLeaf
    extends TrieNode {
        String word;
        Entity entity;
        TrieLeaf next;

        public TrieLeaf(String string, Entity entity) {
            this.word = string;
            this.entity = entity;
            this.next = null;
            this.leafCount = 1;
        }
    }

    public class TrieBranch
    extends TrieNode {
        char[] chars = new char[]{'\u0000'};
        TrieNode[] children = new TrieNode[1];
    }

    public class TrieNode {
        boolean isLeaf;
        int leafCount = 0;
    }
}

