/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class DragControl
extends ControlAdapter {
    private VisualItem activeItem;
    protected Activity update;
    protected Point2D down = new Point2D.Double();
    protected Point2D tmp = new Point2D.Double();
    protected boolean dragged;
    private boolean fixOnMouseOver;
    protected boolean repaint = true;

    public DragControl() {
    }

    public DragControl(boolean bl) {
        this.repaint = bl;
    }

    public DragControl(boolean bl, boolean bl2) {
        this.repaint = bl;
        this.fixOnMouseOver = bl2;
    }

    public DragControl(Activity activity) {
        this.repaint = false;
        this.update = activity;
    }

    public void setFixPositionOnMouseOver(boolean bl) {
        this.fixOnMouseOver = bl;
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
        this.activeItem = visualItem;
        if (this.fixOnMouseOver) {
            visualItem.setFixed(true);
        }
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        if (this.activeItem == visualItem) {
            this.activeItem = null;
            visualItem.setFixed(visualItem.wasFixed());
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.fixOnMouseOver) {
            visualItem.setFixed(true);
        }
        this.dragged = false;
        Display display = (Display)mouseEvent.getComponent();
        this.down = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.dragged) {
            this.activeItem = null;
            visualItem.setFixed(visualItem.wasFixed());
            this.dragged = false;
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.dragged = true;
        Display display = (Display)mouseEvent.getComponent();
        this.tmp = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.tmp);
        double d = this.tmp.getX() - this.down.getX();
        double d2 = this.tmp.getY() - this.down.getY();
        Point2D point2D = visualItem.getLocation();
        visualItem.updateLocation(point2D.getX() + d, point2D.getY() + d2);
        visualItem.setLocation(point2D.getX() + d, point2D.getY() + d2);
        this.down.setLocation(this.tmp);
        if (this.repaint) {
            visualItem.getItemRegistry().repaint();
        }
        if (this.update != null) {
            this.update.runNow();
        }
    }
}

