/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import edu.berkeley.guir.prefuse.focus.DefaultFocusSet;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MultiSelectFocusControl
extends ControlAdapter {
    private static final Object DEFAULT_FOCUS_KEY = "selection";
    private final ItemRegistry registry;
    private final Object focusKey;

    public MultiSelectFocusControl(ItemRegistry itemRegistry) {
        this(itemRegistry, DEFAULT_FOCUS_KEY);
    }

    public MultiSelectFocusControl(ItemRegistry itemRegistry, Object object) {
        this.registry = itemRegistry;
        this.focusKey = object;
        itemRegistry.getFocusManager().putFocusSet(object, new DefaultFocusSet());
    }

    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (visualItem instanceof NodeItem && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            FocusManager focusManager = this.registry.getFocusManager();
            FocusSet focusSet = focusManager.getFocusSet(this.focusKey);
            Entity entity = visualItem.getEntity();
            if (mouseEvent.isShiftDown()) {
                if (focusSet.contains(entity)) {
                    focusSet.remove(entity);
                } else {
                    focusSet.add(entity);
                }
            } else if (!focusManager.isFocus(this.focusKey, entity)) {
                focusSet.set(entity);
            }
            this.registry.touch(visualItem.getItemClass());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.registry.getFocusManager().getFocusSet(this.focusKey).clear();
    }
}

