/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SubtreeDragControl
extends ControlAdapter {
    private VisualItem activeItem;
    private Point2D down = new Point2D.Double();
    private Point2D tmp = new Point2D.Double();
    private boolean wasFixed;
    private boolean repaint = true;

    public SubtreeDragControl() {
    }

    public SubtreeDragControl(boolean bl) {
        this.repaint = bl;
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.down = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
        this.activeItem = visualItem;
        this.wasFixed = visualItem.isFixed();
        visualItem.setFixed(true);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        this.activeItem = null;
        visualItem.setFixed(this.wasFixed);
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.tmp = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.tmp);
        double d = this.tmp.getX() - this.down.getX();
        double d2 = this.tmp.getY() - this.down.getY();
        this.updateLocations((NodeItem)visualItem, d, d2);
        this.down.setLocation(this.tmp);
        if (this.repaint) {
            visualItem.getItemRegistry().repaint();
        }
    }

    private void updateLocations(NodeItem nodeItem, double d, double d2) {
        Point2D point2D = nodeItem.getLocation();
        nodeItem.updateLocation(point2D.getX() + d, point2D.getY() + d2);
        nodeItem.setLocation(point2D.getX() + d, point2D.getY() + d2);
        for (int i = 0; i < nodeItem.getChildCount(); ++i) {
            this.updateLocations((NodeItem)nodeItem.getChild(i), d, d2);
        }
    }
}

