/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import edu.berkeley.guir.prefusex.force.DragForce;
import edu.berkeley.guir.prefusex.force.ForceItem;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.NBodyForce;
import edu.berkeley.guir.prefusex.force.SpringForce;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ForceDirectedLayout
extends Layout {
    protected ItemRegistry registry;
    private ForceSimulator m_fsim;
    private long m_lasttime = -1L;
    private long m_maxstep = 50L;
    private boolean m_runonce;
    private int m_iterations = 100;
    private boolean m_enforceBounds;
    private transient NodeItem referrer;

    public ForceDirectedLayout(boolean bl) {
        this(bl, false);
    }

    public ForceDirectedLayout(boolean bl, boolean bl2) {
        this.m_enforceBounds = bl;
        this.m_runonce = bl2;
        this.m_fsim = new ForceSimulator();
        this.m_fsim.addForce(new NBodyForce());
        this.m_fsim.addForce(new SpringForce());
        this.m_fsim.addForce(new DragForce());
    }

    public ForceDirectedLayout(ForceSimulator forceSimulator, boolean bl) {
        this(forceSimulator, bl, false);
    }

    public ForceDirectedLayout(ForceSimulator forceSimulator, boolean bl, boolean bl2) {
        this.m_enforceBounds = bl;
        this.m_runonce = bl2;
        this.m_fsim = forceSimulator;
    }

    public long getMaxTimeStep() {
        return this.m_maxstep;
    }

    public void setMaxTimeStep(long l) {
        this.m_maxstep = l;
    }

    public ForceSimulator getForceSimulator() {
        return this.m_fsim;
    }

    public void setForceSimulator(ForceSimulator forceSimulator) {
        this.m_fsim = forceSimulator;
    }

    public int getRunOnceIterations() {
        return this.m_iterations;
    }

    public void setRunOnceIterations(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Iterations must be a positive number!");
        }
        this.m_iterations = n;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        this.registry = itemRegistry;
        if (this.m_runonce) {
            Point2D point2D = this.getLayoutAnchor(itemRegistry);
            Iterator iterator = itemRegistry.getNodeItems();
            while (iterator.hasNext()) {
                NodeItem nodeItem = (NodeItem)iterator.next();
                nodeItem.setLocation(point2D);
            }
            this.m_fsim.clear();
            long l = 1000L;
            this.initSimulator(itemRegistry, this.m_fsim);
            for (int i = 0; i < this.m_iterations; ++i) {
                l = (long)((double)l * (1.0 - (double)i / (double)this.m_iterations));
                long l2 = l + 50L;
                this.m_fsim.runSimulator(l2);
                if (i % 10 != 0) continue;
                System.out.println("iter: " + i);
            }
            this.updateNodePositions();
        } else {
            if (this.m_lasttime == -1L) {
                this.m_lasttime = System.currentTimeMillis() - 20L;
            }
            long l = System.currentTimeMillis();
            long l3 = Math.min(this.m_maxstep, l - this.m_lasttime);
            this.m_lasttime = l;
            this.m_fsim.clear();
            this.initSimulator(itemRegistry, this.m_fsim);
            this.m_fsim.runSimulator(l3);
            this.updateNodePositions();
        }
        this.registry = null;
        if (d == 1.0) {
            this.reset(itemRegistry);
        }
    }

    private void updateNodePositions() {
        Rectangle2D rectangle2D = this.getLayoutBounds(this.registry);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (rectangle2D != null) {
            d = rectangle2D.getMinX();
            d3 = rectangle2D.getMinY();
            d2 = rectangle2D.getMaxX();
            d4 = rectangle2D.getMaxY();
        }
        Iterator iterator = this.registry.getNodeItems();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            ForceItem forceItem = (ForceItem)nodeItem.getVizAttribute("forceItem");
            if (nodeItem.isFixed()) {
                forceItem.force[0] = 0.0f;
                forceItem.force[1] = 0.0f;
                forceItem.velocity[0] = 0.0f;
                forceItem.velocity[1] = 0.0f;
                if (!Double.isNaN(nodeItem.getX())) continue;
                this.setLocation(nodeItem, this.referrer, 0.0, 0.0);
                continue;
            }
            double d5 = forceItem.location[0];
            double d6 = forceItem.location[1];
            if (this.m_enforceBounds && rectangle2D != null) {
                Rectangle2D rectangle2D2 = nodeItem.getBounds();
                double d7 = rectangle2D2.getWidth() / 2.0;
                double d8 = rectangle2D2.getHeight() / 2.0;
                if (d5 + d7 > d2) {
                    d5 = d2 - d7;
                }
                if (d5 - d7 < d) {
                    d5 = d + d7;
                }
                if (d6 + d8 > d4) {
                    d6 = d4 - d8;
                }
                if (d6 - d8 < d3) {
                    d6 = d3 + d8;
                }
            }
            this.setLocation(nodeItem, this.referrer, d5, d6);
        }
    }

    public void reset(ItemRegistry itemRegistry) {
        Iterator iterator = itemRegistry.getNodeItems();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            ForceItem forceItem = (ForceItem)nodeItem.getVizAttribute("forceItem");
            if (forceItem == null) continue;
            forceItem.location[0] = (float)nodeItem.getEndLocation().getX();
            forceItem.location[1] = (float)nodeItem.getEndLocation().getY();
            forceItem.force[1] = 0.0f;
            forceItem.force[0] = 0.0f;
            forceItem.velocity[1] = 0.0f;
            forceItem.velocity[0] = 0.0f;
        }
        this.m_lasttime = -1L;
    }

    protected void initSimulator(ItemRegistry itemRegistry, ForceSimulator forceSimulator) {
        Object object;
        VisualItem visualItem;
        float f = this.referrer == null ? 0.0f : (float)this.referrer.getX();
        float f2 = this.referrer == null ? 0.0f : (float)this.referrer.getY();
        f = Float.isNaN(f) ? 0.0f : f;
        f2 = Float.isNaN(f2) ? 0.0f : f2;
        Iterator iterator = itemRegistry.getNodeItems();
        while (iterator.hasNext()) {
            visualItem = (NodeItem)iterator.next();
            object = (ForceItem)visualItem.getVizAttribute("forceItem");
            if (object == null) {
                object = new ForceItem();
                visualItem.setVizAttribute("forceItem", object);
            }
            ((ForceItem)object).mass = this.getMassValue((NodeItem)visualItem);
            double d = visualItem.getEndLocation().getX();
            double d2 = visualItem.getEndLocation().getY();
            ((ForceItem)object).location[0] = Double.isNaN(d) ? f : (float)d;
            ((ForceItem)object).location[1] = Double.isNaN(d2) ? f2 : (float)d2;
            forceSimulator.addItem((ForceItem)object);
        }
        iterator = itemRegistry.getEdgeItems();
        while (iterator.hasNext()) {
            visualItem = (EdgeItem)iterator.next();
            object = (NodeItem)((EdgeItem)visualItem).getFirstNode();
            ForceItem forceItem = (ForceItem)((VisualItem)object).getVizAttribute("forceItem");
            NodeItem nodeItem = (NodeItem)((EdgeItem)visualItem).getSecondNode();
            ForceItem forceItem2 = (ForceItem)nodeItem.getVizAttribute("forceItem");
            float f3 = this.getSpringCoefficient((EdgeItem)visualItem);
            float f4 = this.getSpringLength((EdgeItem)visualItem);
            forceSimulator.addSpring(forceItem, forceItem2, f3 >= 0.0f ? f3 : -1.0f, f4 >= 0.0f ? f4 : -1.0f);
        }
    }

    protected float getMassValue(NodeItem nodeItem) {
        return 1.0f;
    }

    protected float getSpringLength(EdgeItem edgeItem) {
        return -1.0f;
    }

    protected float getSpringCoefficient(EdgeItem edgeItem) {
        return -1.0f;
    }

    public NodeItem getReferrer() {
        return this.referrer;
    }

    public void setReferrer(NodeItem nodeItem) {
        this.referrer = nodeItem;
    }
}

