/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.serialize.StreamWriterToContentHandlerConverter;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.dom.SOAPElement;
import org.apache.axiom.soap.impl.dom.SOAPFaultRoleImpl;

public abstract class SOAPFaultImpl
extends SOAPElement
implements SOAPFault,
OMConstants {
    protected Exception e;

    public SOAPFaultImpl(SOAPBody parent, Exception e, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true, factory);
        this.setException(e);
    }

    public void setException(Exception e) {
        this.e = e;
        this.putExceptionToSOAPFault(e);
    }

    public SOAPFaultImpl(SOAPBody parent, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true, factory);
    }

    public SOAPFaultImpl(SOAPBody parent, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)parent, "Fault", builder, factory);
    }

    protected abstract SOAPFaultDetail getNewSOAPFaultDetail(SOAPFault var1) throws SOAPProcessingException;

    public void setCode(SOAPFaultCode soapFaultCode) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getCode(), (OMElement)soapFaultCode);
    }

    public SOAPFaultCode getCode() {
        return (SOAPFaultCode)this.getChildWithName("Code");
    }

    public void setReason(SOAPFaultReason reason) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getReason(), (OMElement)reason);
    }

    public SOAPFaultReason getReason() {
        return (SOAPFaultReason)this.getChildWithName("Reason");
    }

    public void setNode(SOAPFaultNode node) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getNode(), (OMElement)node);
    }

    public SOAPFaultNode getNode() {
        return (SOAPFaultNode)this.getChildWithName("Node");
    }

    public void setRole(SOAPFaultRole role) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getRole(), (OMElement)role);
    }

    public SOAPFaultRole getRole() {
        return (SOAPFaultRoleImpl)this.getChildWithName("Role");
    }

    public void setDetail(SOAPFaultDetail detail) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getDetail(), (OMElement)detail);
    }

    public SOAPFaultDetail getDetail() {
        return (SOAPFaultDetail)this.getChildWithName("Detail");
    }

    public Exception getException() throws OMException {
        SOAPFaultDetail detail = this.getDetail();
        if (detail == null) {
            return null;
        }
        OMElement exceptionElement = this.getDetail().getFirstChildWithName(new QName("Exception"));
        if (exceptionElement != null && exceptionElement.getText() != null) {
            return new Exception(exceptionElement.getText());
        }
        return null;
    }

    protected void putExceptionToSOAPFault(Exception e) throws SOAPProcessingException {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        this.getDetail();
        if (this.getDetail() == null) {
            this.setDetail(this.getNewSOAPFaultDetail(this));
        }
        ElementImpl faultDetailEnty = new ElementImpl(this, "Exception", null, this.factory);
        faultDetailEnty.setText(sw.getBuffer().toString());
    }

    protected void setNewElement(OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        if (newElement != null && newElement.getParent() != null) {
            newElement.discard();
        }
        this.addChild((OMNode)newElement);
        myElement = newElement;
    }

    protected OMElement getChildWithName(String childName) {
        Iterator childrenIter = this.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        SOAPFaultDetail faultDetail;
        SOAPFaultReason faultReason;
        short builderType = 1;
        if (this.builder != null) {
            builderType = this.builder.getBuilderType();
        }
        if (builderType == 0 && this.builder.getRegisteredContentHandler() == null) {
            this.builder.registerExternalContentHandler((Object)new StreamWriterToContentHandlerConverter(writer));
        }
        this.build();
        OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
        SOAPFaultCode faultCode = this.getCode();
        if (faultCode != null) {
            faultCode.serialize(writer);
        }
        if ((faultReason = this.getReason()) != null) {
            faultReason.serialize(writer);
        }
        this.serializeFaultNode(writer);
        SOAPFaultRole faultRole = this.getRole();
        if (faultRole != null) {
            faultRole.serialize(writer);
        }
        if ((faultDetail = this.getDetail()) != null) {
            faultDetail.serialize(writer);
        }
        OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
    }

    protected abstract void serializeFaultNode(XMLStreamWriter var1) throws XMLStreamException;
}

