/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeader;

public class AxisFault
extends RemoteException {
    private static final long serialVersionUID = -374933082062124907L;
    private List headers = new ArrayList(0);
    private List faultReasonList = new ArrayList(1);
    private QName faultCode;
    private String faultNode;
    private String faultRole;
    private OMElement detail;
    private Map faultElements;
    private String message;
    private Throwable cause;
    private String nodeURI;

    public AxisFault(String message) {
        super(message);
        this.addReason(message);
    }

    public AxisFault(QName faultCode, String faultReason, Throwable cause) {
        this(faultReason, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(QName faultCode, String faultReason, String faultNode, String faultRole, OMElement faultDetail) {
        this(faultReason, faultCode);
        this.faultNode = faultNode;
        this.faultRole = faultRole;
        this.setDetail(faultDetail);
    }

    public AxisFault(SOAPFaultCode soapFaultCode, SOAPFaultReason soapFaultReason, SOAPFaultNode soapFaultNode, SOAPFaultRole soapFaultRole, SOAPFaultDetail soapFaultDetail) {
        if (this.faultElements == null) {
            this.faultElements = new HashMap(3);
        }
        this.setToElementsListIfNotNull("Code", (OMElement)soapFaultCode);
        this.setToElementsListIfNotNull("Reason", (OMElement)soapFaultReason);
        this.setToElementsListIfNotNull("Node", (OMElement)soapFaultNode);
        this.setToElementsListIfNotNull("Role", (OMElement)soapFaultRole);
        this.setToElementsListIfNotNull("Detail", (OMElement)soapFaultDetail);
        if (soapFaultReason != null) {
            this.message = soapFaultReason.getFirstSOAPText().getText();
        }
        if (soapFaultDetail != null) {
            OMElement exceptionElement = soapFaultDetail.getFirstChildWithName(new QName("Exception"));
            if (exceptionElement != null && exceptionElement.getText() != null) {
                this.cause = new Exception(exceptionElement.getText());
            }
            this.detail = soapFaultDetail.getFirstElement();
        }
        if (soapFaultCode != null && soapFaultCode.getValue() != null) {
            this.faultCode = soapFaultCode.getValue().getTextAsQName();
        }
    }

    private void setToElementsListIfNotNull(String soapFaultElementName, OMElement soapFaultElement) {
        if (soapFaultElement != null) {
            this.faultElements.put(soapFaultElementName, soapFaultElement);
        }
    }

    public AxisFault(Throwable cause) {
        this(cause != null ? cause.getMessage() : null, cause);
    }

    public AxisFault(String messageText, String faultCode) {
        this(messageText);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String messageText, QName faultCode) {
        this(messageText);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String message, Throwable cause) {
        super(message, cause);
        if (message != null) {
            this.addReason(message);
        }
    }

    public AxisFault(String messageText, QName faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public AxisFault(String messageText, String faultCode, Throwable cause) {
        this(messageText, cause);
        this.setFaultCode(faultCode);
    }

    public void addHeader(SOAPHeader header) {
        this.headers.add(header);
    }

    public void addReason(String text) {
        this.faultReasonList.add(new FaultReason(text, ""));
    }

    public void addReason(String text, String language) {
        this.faultReasonList.add(new FaultReason(text, language));
    }

    public String getReason() {
        if (this.faultReasonList.size() >= 1) {
            return ((FaultReason)this.faultReasonList.get(0)).getText();
        }
        return null;
    }

    public ListIterator headerIterator() {
        return this.headers.listIterator();
    }

    public List headers() {
        return this.headers;
    }

    public static AxisFault makeFault(Exception e) {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
            e = (Exception)t;
        }
        if (e instanceof AxisFault) {
            return (AxisFault)e;
        }
        return new AxisFault(e);
    }

    public OMElement getDetail() {
        return this.detail;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public SOAPFaultCode getFaultCodeElement() {
        return this.faultElements != null ? this.faultElements.get("Code") : null;
    }

    public SOAPFaultReason getFaultReasonElement() {
        return this.faultElements != null ? this.faultElements.get("Reason") : null;
    }

    public SOAPFaultNode getFaultNodeElement() {
        return this.faultElements != null ? this.faultElements.get("Node") : null;
    }

    public SOAPFaultRole getFaultRoleElement() {
        return this.faultElements != null ? this.faultElements.get("Role") : null;
    }

    public SOAPFaultDetail getFaultDetailElement() {
        return this.faultElements != null ? this.faultElements.get("Detail") : null;
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public void setDetail(OMElement detail) {
        this.detail = detail;
    }

    public void setFaultCode(QName soapFaultCode) {
        this.faultCode = soapFaultCode;
    }

    public void setFaultCode(String soapFaultCode) {
        this.faultCode = new QName(soapFaultCode);
    }

    public void setNodeURI(String nodeURI) {
        this.nodeURI = nodeURI;
    }

    public Map getFaultElements() {
        return this.faultElements;
    }

    public String getFaultNode() {
        return this.faultNode;
    }

    public String getFaultRole() {
        return this.faultRole;
    }

    public String getMessage() {
        return this.message != null ? this.message : super.getMessage();
    }

    public Throwable getCause() {
        return this.cause != null ? this.cause : super.getCause();
    }

    class FaultReason {
        private String language = "";
        private String text;

        public FaultReason() {
        }

        public FaultReason(String text, String language) {
            this.text = text;
            this.language = language;
        }

        public String toString() {
            return this.text;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getText() {
            return this.text;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

