/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointReference
implements Serializable {
    private static final long serialVersionUID = 5278892171162372439L;
    private static final Log log = LogFactory.getLog((Class)EndpointReference.class);
    private String name;
    private String address;
    private ArrayList metaData;
    private Map referenceParameters;
    private ArrayList extensibleElements;
    private ArrayList attributes;

    public EndpointReference(String address) {
        this.address = address;
    }

    public void addReferenceParameter(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new HashMap();
        }
        this.referenceParameters.put(omElement.getQName(), omElement);
    }

    public void addReferenceParameter(QName qname, String value) {
        if (qname == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname, null);
        omElement.setText(value);
        this.addReferenceParameter(omElement);
    }

    public Map getAllReferenceParameters() {
        return this.referenceParameters;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean hasAnonymousAddress() {
        boolean result;
        boolean bl = result = "http://www.w3.org/2005/08/addressing/anonymous".equals(this.address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(this.address);
        if (log.isTraceEnabled()) {
            log.trace((Object)("hasAnonymousAddress: " + this.address + " is Anonymous: " + result));
        }
        return result;
    }

    public boolean hasNoneAddress() {
        boolean result = "http://www.w3.org/2005/08/addressing/none".equals(this.address);
        if (log.isTraceEnabled()) {
            log.trace((Object)("hasNoneAddress: " + this.address + " is None: " + result));
        }
        return result;
    }

    public void addAttribute(String localName, OMNamespace ns, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(OMAbstractFactory.getOMFactory().createOMAttribute(localName, ns, value));
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public void addAttribute(OMAttribute omAttribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(omAttribute);
    }

    public ArrayList getExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(ArrayList extensibleElements) {
        this.extensibleElements = extensibleElements;
    }

    public void addExtensibleElement(OMElement extensibleElement) {
        if (extensibleElement != null) {
            if (this.extensibleElements == null) {
                this.extensibleElements = new ArrayList();
            }
            this.extensibleElements.add(extensibleElement);
        }
    }

    public ArrayList getMetaData() {
        return this.metaData;
    }

    public void addMetaData(OMNode metaData) {
        if (metaData != null) {
            if (this.metaData == null) {
                this.metaData = new ArrayList();
            }
            this.metaData.add(metaData);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceParameters(Map referenceParameters) {
        this.referenceParameters = referenceParameters;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Address: " + this.address);
        if (this.metaData != null) {
            buffer.append(", Metadata: ").append(this.metaData);
        }
        if (this.referenceParameters != null) {
            buffer.append(", Reference Parameters: ").append(this.referenceParameters);
        }
        if (this.extensibleElements != null) {
            buffer.append(", Extensibility elements: ").append(this.extensibleElements);
        }
        if (this.attributes != null) {
            buffer.append(", Attributes: ").append(this.attributes);
        }
        return buffer.toString();
    }

    public void fromOM(OMElement eprOMElement) {
        OMElement metaDataElement;
        this.setAddress(eprOMElement.getFirstChildWithName(new QName("Address")).getText());
        OMElement refParamElement = eprOMElement.getFirstChildWithName(new QName("ReferenceParameters"));
        if (refParamElement != null) {
            Iterator refParams = refParamElement.getChildElements();
            while (refParams.hasNext()) {
                OMElement omElement = (OMElement)refParams.next();
                this.addReferenceParameter(omElement);
            }
        }
        if ((metaDataElement = eprOMElement.getFirstChildWithName(new QName("Metadata"))) != null) {
            Iterator children = metaDataElement.getChildren();
            while (children.hasNext()) {
                OMNode omNode = (OMNode)children.next();
                this.addMetaData(omNode);
            }
        }
        this.setName(eprOMElement.getLocalName());
        Iterator allAttributes = eprOMElement.getAllAttributes();
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        while (allAttributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)allAttributes.next();
            this.attributes.add(attribute);
        }
        Iterator childElements = eprOMElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement eprChildElement = (OMElement)childElements.next();
            String localName = eprChildElement.getLocalName();
            if (localName.equals("Address") || localName.equals("ReferenceParameters") || localName.equals("Metadata")) continue;
            this.addExtensibleElement(eprChildElement);
        }
    }

    public OMElement toOM(String nsurl, String localName, String prefix) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (prefix != null) {
            ArrayList omElements;
            OMNamespace wrapNs = fac.createOMNamespace(nsurl, prefix);
            OMElement epr = fac.createOMElement(localName, wrapNs);
            OMNamespace wsaNS = fac.createOMNamespace("http://www.w3.org/2005/08/addressing", "wsa");
            OMElement addressE = fac.createOMElement("Address", wsaNS, (OMContainer)epr);
            addressE.setText(this.address);
            if (this.metaData != null) {
                OMElement metadataE = fac.createOMElement("Metadata", wsaNS, (OMContainer)epr);
                Iterator metadata = this.metaData.iterator();
                while (metadata.hasNext()) {
                    metadataE.addChild((OMNode)metadata.next());
                }
            }
            if (this.referenceParameters != null) {
                OMElement refParameterElement = fac.createOMElement("ReferenceParameters", wsaNS, (OMContainer)epr);
                Iterator refParms = this.referenceParameters.values().iterator();
                while (refParms.hasNext()) {
                    refParameterElement.addChild((OMNode)refParms.next());
                }
            }
            if (this.attributes != null) {
                Iterator attrIter = this.attributes.iterator();
                while (attrIter.hasNext()) {
                    OMAttribute omAttributes = (OMAttribute)attrIter.next();
                    epr.addAttribute(omAttributes);
                }
            }
            if ((omElements = this.extensibleElements) != null) {
                for (int i = 0; i < omElements.size(); ++i) {
                    epr.addChild((OMNode)((OMElement)omElements.get(i)));
                }
            }
            return epr;
        }
        throw new AxisFault("prefix must be specified");
    }
}

