/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.HTTPConstants;

public class InstanceDispatcher
extends AbstractHandler {
    private static final QName SERVICE_GROUP_QNAME = new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2");

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisOperation axisOperation;
        AxisService service = msgContext.getAxisService();
        String scope = service == null ? null : service.getScope();
        ServiceContext serviceContext = msgContext.getServiceContext();
        if (msgContext.getOperationContext() != null && serviceContext != null) {
            msgContext.setServiceGroupContextId(((ServiceGroupContext)serviceContext.getParent()).getId());
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!"application".equals(scope)) {
            this.extractServiceGroupContextId(msgContext);
            this.fillContextsFromSessionContext(msgContext);
        }
        if ((axisOperation = msgContext.getAxisOperation()) == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        OperationContext operationContext = axisOperation.findForExistingOperationContext(msgContext);
        if (operationContext != null) {
            axisOperation.registerMessageContext(msgContext, operationContext);
            serviceContext = (ServiceContext)operationContext.getParent();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceContext.getParent();
            msgContext.setServiceContext(serviceContext);
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceGroupContextId(serviceGroupContext.getId());
        } else {
            operationContext = new OperationContext(axisOperation);
            axisOperation.registerMessageContext(msgContext, operationContext);
            if (serviceContext != null) {
                operationContext.setParent(serviceContext);
            } else {
                msgContext.getConfigurationContext().fillServiceContextAndServiceGroupContext(msgContext);
            }
        }
        if (serviceContext != null) {
            serviceContext.setMyEPR(msgContext.getTo());
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void fillContextsFromSessionContext(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext;
        ServiceGroupContext serviceGroupContext;
        String serviceGroupContextId;
        Object obj;
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            throw new AxisFault(Messages.getMessage("unabletofindservice"));
        }
        SessionContext sessionContext = msgContext.getSessionContext();
        String scope = service.getScope();
        if ("transportsession".equals(scope) && sessionContext == null && (obj = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) != null) {
            sessionContext = (SessionContext)this.getSessionContext((HttpServletRequest)obj);
            msgContext.setSessionContext(sessionContext);
        }
        if ((serviceGroupContextId = msgContext.getServiceGroupContextId()) != null && sessionContext != null && (serviceGroupContext = sessionContext.getServiceGroupContext(serviceGroupContextId)) != null) {
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceContext(serviceGroupContext.getServiceContext(service));
            return;
        }
        if ("transportsession".equals(scope) && sessionContext != null && (serviceContext = sessionContext.getServiceContext(service)) != null) {
            msgContext.setServiceContext(serviceContext);
        }
    }

    private void extractServiceGroupContextId(MessageContext msgContext) throws AxisFault {
        OMElement serviceGroupId;
        if (!msgContext.isHeaderPresent()) {
            return;
        }
        SOAPHeader soapHeader = msgContext.getEnvelope().getHeader();
        if (soapHeader != null && (serviceGroupId = soapHeader.getFirstChildWithName(SERVICE_GROUP_QNAME)) != null) {
            String groupId = serviceGroupId.getText();
            ServiceGroupContext serviceGroupContext = msgContext.getConfigurationContext().getServiceGroupContext(groupId, msgContext);
            if (serviceGroupContext == null) {
                throw new AxisFault(Messages.getMessage("invalidservicegrouoid", groupId));
            }
            msgContext.setServiceGroupContextId(serviceGroupId.getText());
        }
    }

    private Object getSessionContext(HttpServletRequest httpServletRequest) {
        Object sessionContext = httpServletRequest.getSession(true).getAttribute("SessionContext");
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            httpServletRequest.getSession().setAttribute("SessionContext", sessionContext);
        }
        return sessionContext;
    }
}

