/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisRESTServlet
extends AxisServlet {
    private static final Log log = LogFactory.getLog((Class)AxisRESTServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.disableREST && !this.disableSeperateEndpointForREST) {
            MessageContext messageContext = null;
            try {
                messageContext = this.createMessageContext(req, resp);
                new RESTUtil(this.configContext).processGetRequest(messageContext, req, resp);
            }
            catch (Exception e) {
                log.error((Object)e);
                if (messageContext != null) {
                    resp.setStatus(500);
                    this.handleFault(messageContext, (OutputStream)resp.getOutputStream(), new AxisFault(e));
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.disableREST && !this.disableSeperateEndpointForREST) {
            MessageContext messageContext = null;
            try {
                messageContext = this.createMessageContext(req, resp);
                new RESTUtil(this.configContext).processPostRequest(messageContext, req, resp);
            }
            catch (Exception e) {
                log.error((Object)e);
                if (messageContext != null) {
                    resp.setStatus(500);
                    this.handleFault(messageContext, (OutputStream)resp.getOutputStream(), new AxisFault(e));
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this.configContext = (ConfigurationContext)servletContext.getAttribute("CONFIGURATION_CONTEXT");
        servletContext.setAttribute(this.getClass().getName(), (Object)this);
        this.servletConfig = config;
        this.axisConfiguration = this.configContext.getAxisConfiguration();
        this.initParams();
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }
}

